/* OdmConnection.java 0.07           UTF-8                   dh:2006-12-17
 *
 * The OdmConnection interface provides a connection to ODMA on behalf
 * of the currently-running application.  A reference to this interface
 * should be held as long as the application will be creating and accessing
 * document files via ODMA-aware behavopr.
 *
 * It is safe to release an OdmConnection interface implementation once it
 * is certain that there is no further need for any of its ODMJNI functions.
 *
 * Releasing an OdmConnection interface does not interfere with existing
 * OdmDocument interfaces that are held by the application.  If for some
 * reason more than one instance of an OdmConnection implementation has
 * been created, the releases of the separate OdmConnection instances are
 * independent.
 */

package info.odma.practical100;

public interface OdmConnection extends OdmInterface
{
    boolean dmsDefaultAvailable();
        /* True when there is a default ODMA DMS assigned to the current
           application.  The acceptNewDocument() and chooseDocument()
           operations always require a default ODMA DMS to be available.

           If true is returned, that will continue to be the result until
           the interface is released.  dmsDefaultAvailable() is never true
           when OdmConnection.available() is false.

               Null response: false.
           */

    OdmPendingDocument acceptNewDocument(java.lang.String docFormatName)
                            throws OdmError;
        /* Used to offer content to the DMS for making a new managed
           document.  This is usually when a fresh unsaved document has been
           created in an application and the operator chooses to save the
           content of that document.  It can also be the first step of a
           "Save As ..." of content obtained from a file-system location or
           from a different DMS.

           The docFormatName parameter specifies the file extension of the
           format of document file that the application is offering to the
           Default DMS.  If the docFormatName is ill-formed, an unchecked
           OdmError exception is thrown.

           The returned OdmPendingDocument interface must be consulted to
           determine if a default DMS is ready to accept the document
           content or some other course of action is required.  See the
           OdmDocument interface for the operations that apply.

           If dmsDefaultAvailable() is false, null behavior is provided.

               Null behavior: a pending-document interface for a null-
                              document implementation is returned.  Its
                              localDocumentRequested() operation will
                              return true.
           */

    OdmWorkingDocument chooseDocument();
        /* Requests that the ODMA DMS choose a document for the application
           to use.  This is typically when the application user requests
           opening of a document.  By convention, the ODMA connection is
           to be given "first refusal" in ODMJNI 1.0 usage scenarios.

           The returned OdmWorkingDocument interface must be consulted to
           determine if a default-DMS document has been selected for access
           by the application or not.

           If dmsDefaultAvailable() is false, null behavior is provided.

               Null behavior: a working-document interface for a null-
                              document implementation is returned.  Its
                              localDocumentRequested() operation will
                              return true.
           */

    OdmWorkingDocument openKnownDocument(java.lang.String docID)
                            throws OdmError;
        /* Requests that the ODMA connection open a known managed document
           whose ODMA Document ID is specified in the docID parameter.  If
           the docID string is not well-formed, an OdmError exception is
           thrown.

           If the identified document is accessible and the application
           account is authorized to obtain it, the request is handled the
           same as if the identified document had been selected in a
           chooseDocument() operation.

           The returned OdmWorkingDocument interface must be consulted to
           determine if an ODMA DMS has returned the managed document for
           the application to access.

           If OdmConnection.available() is false or the DMS identified in
           the docID parameter is inaccessible, null behavior is provided.

               Null behavior: a working-document interface for a null-
                              document implementation is returned.  It
                              will indicate that the operation failed.
                              No alternative action is indicated in the
                              result.
           */

    } /* Connection */


/* 0.07 2006-12-17-13:16 Add throws OdmError clauses and adjust the
        explanations to reflect null-on-null and also include accumulated
        editorial changes.
   0.06 2006-12-13-20:24 Reflect the change from availableConnection()
        to OdmConnection.available().
   0.05 2006-12-12-21:12 Review and adjust for the 0.30beta release.
   0.04 2006-10-22-20:32 Make interface public.
   0.03 2006-10-22-17:00 Provide comments and clean compile to work with
        0.05alpha versions of OdmPendingDocument and OdmWorkingDocument
   0.02 2006-10-22-14:00 Modify for new name and extending odmInterface
   0.01 2006-10-19-00:09 Obtain clean compilation
   0.00 2006-10-18-21:40 alpha-level version for the first evolutionary
        prototype of ODMJNI components.  This interface is intended to
        become stable very quickly during early testing and application
        integration.

   $Header: /ODMdev/info/odma/practical100/OdmConnection.java 11    06-12-17 13:39 Orcmid $
   */

/*       *** end of info.odma.practical100.OdmConnection.java ***      */