/* OdmNull.java 0.01                 UTF-8                   dh:2006-12-18
 *
 * The OdmNull interface delivers the six null-behavior cases.
 *
 * The interface is intended to be implemented by a class that caches these
 * particular instances so they can be reused wherever and as often they
 * are needed for delivery by ODMJNI 1.0 methods.
 */


package info.odma.practical100;

public interface OdmNull
{

    OdmPendingDocument pendingFailed();
        /* returns a null OdmPendingDocument with failure status */


    OdmPendingDocument pendingCancelled();
        /* returns a null OdmPendingDocument with cancelled status */


    OdmPendingDocument pendingLocalOperation();
       /* returns a null OdmPendingDocument with local-operation requested
          status */


    OdmWorkingDocument workingFailed();
       /* returns a null OdmWorkingDocument with failure status */


    OdmWorkingDocument workingCancelled();
       /* returns a null OdmWorkingDocument with cancelled status */


    OdmWorkingDocument workingLocalOperation();
       /* returns a null OdmWorkingDocument with local-operation requested
          status */


    } /* OdmNull */


/* 0.01 2006-12-18-20:29 removed unnecessary access specifiers from the
        interface methods.
   0.00 2006-12-18-19:44 derive by extracting material from the 0.08 version
        of OdmNullConnection.

   $Header: /ODMdev/info/odma/practical100/OdmNull.java 3     06-12-18 20:30 Orcmid $
   */

/*         *** end of info.odma.practical100.OdmNull.java ***          */