/* OdmWorking100.hpp 0.04            UTF-8                   dh:2007-01-01
 *
 *               OdmWorking100 ENTRY AND INTERFACE DEFINITIONS
 *               *********************************************
 *
 * This header file defines the various OdmWorking100 interfaces and the
 * entry to the OdmBindWorking100 class factory function.  This function
 * and the interfaces to the COM object it creates provide all of the
 * OdmNative support required to implement an OdmWorkingDocument interface
 * for ODMJNI.  Only the public IodmWorking100 interface is defined.  The
 * factory function is private to the OdmNative class implementations.
 *
 * There may be other uses for OdmNative interfaces and classes in the
 * future, but for now the purposes and use cases for the interfaces
 * are stated in terms of ODMJNI feature behavior.
 *
 *                       Copyright © 2006-2007 NuovoDoc
 *                           <http://NuovoDoc.com>
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source files that include this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 *
 * FIXME: There will be a major refactoring to raise the level of abstrac-
 *        tion and encapsulation in the delivery of practical functions
 *        that return HRESULTs and express the still-needed ODMSTATUS
 *        values in HRESULTS for compact delivery of completed operations.
 *
 *        The preamble to OdmNative100.hpp for more about the motivation
 *        and approach.
 *
 *        These changes will not occur before the 0.50 beta ODMJNI 1.0
 *        release.
 */


#ifndef ODMWORKING100_H
#define ODMWORKING100_H

#define OdmWorking100_H_Version_ "0.04 OdmWorking100.hpp " \
                                "2007-01-01T20:09Z"

    /* This is a preprocessor text about this header file.  It is a
       string value that can be incorporated into other text.
       */

#ifndef __cplusplus
#error  IodmWorking100 INTERFACE DEFINITION REQUIRES C++.  DON'T USE WITH C.
    /* XXX: We might fix this some day, but not now. */
#endif

#include <windows.h>

#include "Odma32types100.h"
    /* Stick with the ODMA 1.0 Types and Values definitions */

/*                        Define IodmWorking IID Values
                          ***************************** */

    /*  Each interface has a globally-unique Interface ID (IID).  The
        IIDs are specified by Microsoft for the standard COM interfaces
        such as IUnknown.  For the IodmNative-unique interfaces, the IIDs
        have been generated using the GuidGen.exe tool provided with
        the Microsoft Platform SDK.
        */


#define IID_IodmWorking100_ { 0xef1a31d4, 0x1e0c, 0x4f8c, \
               { 0x8d, 0x5e, 0x7, 0xd8, 0x39, 0x86, 0x65, 0xe0 } }


        /* This IID represents both the signature and the contract for
           the 0.30alpha version of IodmWorking100.  Every time the
           signature and contract change for a version released to the
           wild, there will be a new IID.  This is a safeguard against
           calling for an implementation of a different interface contract
           than the one represented by this header file and definition of
           the associated behavior.

           See the explanation in OdmNative100.hpp for further details of
           this approach.
           */


/*                     Define IodmWorking Interface
                       **************************** */


interface IodmWorking100 : IUnknown
{   /* Inherit from IUnknown as required for all COM interfaces

       This interface is only available for a successfully-created,
       fully usable document object.  The ODMA Document ID is known
       and the document file has been delivered to the docLocation.
       It is also known whether the document is viewable or not.

       This implementation does not attempt to optimize performance by
       caching document properties or other speed-ups.  The ODMJNI
       classes are better able to do that using java.lang.String
       references that they can keep except when refreshing is required.
       In particular, OdmWorking100 is relieved from having to know which
       events might cause the result of a request to change.

       More assumptions about the conditions under which this interface
       should ever be delivered are provided in the comments on the
       individual (groups of) methods.
       */

    /* ODMJNI OdmInterface Counterparts in IodmWorking
     * -----------------------------------------------
     *
     * For this interface to have been produced, it must have been the
     * case that IodmApplication100.hasConMan() is true and remains true
     * so long as there is any implementation of the IodmWorking100
     * interface that has not been released.
     *
     * The counterpart of ODMJNI OdmInterface.release() is the
     * IUnknown::release() method.  There is no separate release and
     * there is no interface available after release, so there is no
     * need for null behaviors on the methods.  This must be handled in
     * the wrapper, whether ODMJNI or some other wrapper.
     */

    virtual LPCSTR WINAPI interfaceImplementation(void) PURE;
        /* A constant '\0'-terminated char string of '\n'-separated lines
           that identify the version of I0dmWorking100 implementation.
           This constant is available only so long as the interface is
           held.  A copy must be made for use beyond that duration.

           FIXME: We need a defined convention for this format and how
           to use it in reporting, as in an eventlog or test report.  That
           applies for all of the OdmNative cases of this interface.
           */


    /* ODMJNI OdmDocument Counterparts in IodmWorking100
     * -------------------------------------------------
     *
     * For an IodmWorking100 interface to have been delivered, it must
     * be the case that, for a wrapper like ODMJNI,
     *
     *         OdmDocument.dmsAvailable() is true.
     *
     *         OdmDocument.operationSucceeded() is true.
     *                    .operationCancelled() is false.
     *                    .localOperationRequested() is false.
     *
     * There is no need for IodmWorking100 to provide counterparts
     * of any of those functions.
     *
     * In terms of OdmNative and ODMA operations, it must be the case that
     *
     *         IodmApplication100i.hConManLib() is non-NULL
     *         IodmApplication100i.hWorkingDMS() is a non-NULL ODMHANDLE
     *
     * and the ODMA Document Id and ODMA Document Location parameters used
     * in the implementation of the interface are valid and accessible to
     * the application of OdmWorking100.
     */


    /* ODMJNI OdmViewingDocument Counterparts in IodmWorking100
     * --------------------------------------------------------
     *
     * The OdmViewingDocument functions are supported by the following
     * IodmWorking100 methods.
     */


    virtual BOOL WINAPI viewOnly(void) PURE;
        /* Indicates whether or not the document file that this interface
           represents is a viewOnly document or not.  This is always TRUE
           if TRUE was provided when the document was constructed.
           */


    virtual LPCSTR WINAPI docID(void) PURE;
        /* The ODMA DMS representation of the ODMA Document ID is reflected
           in this string.  There is always an ODMA docID value available.
           It will not have been localized in any way.  This is the form
           that was provided by the DMS (or the application) when the
           IodmWorking100 document object was instantiated.  It will not
           exceed ODM_DOCID_MAX octets, including the trailing '\0' byte.

           This string is available only until the IodmWorking100 interface
           is released.  Any reference to the string will be invalid after
           release.

           Although the string is constant, it can change following any
           commitChanges.  It will never change when viewOnly() holds.

           If commitChanges fails, the last value will be retained.  It
           is not necessarily meaningful if viewOnly() is FALSE and
           commitChanges has failed.
           */


    virtual LPCSTR WINAPI docLocation(void) PURE;
        /* The ODMA DMS representation of the common file location is
           carried in this string.  There must always be an ODMA docLocation
           reflected in this string.

           This string is available only until the IodmWorking100 interface
           is released.  Any reference to the string will be invalid after
           release.

           This string does not change, whether viewOnly() holds or not.

           If commitChanges fails, the last value will be retained.  It is
           not necessarily meaningful if viewOnly() is FALSE, however.
           */


    virtual ODMSTATUS WINAPI
                docProperty(  WORD propNum,
                             LPSTR lpszData,
                              WORD dataLen
                              )
                        PURE;

        /* The Property value is returned for the specified propNum, if
           available.

           propNum is one of the following values:

                    ODM_TITLETEXT  windowTitle value
                       ODM_AUTHOR  dmsAuthor value
                         ODM_NAME  dmsDocName value
                         ODM_TYPE  dmsDocType value
                ODM_CONTENTFORMAT  dmsFormatName value

                Any other values lead to a null result and an ODM_E_ITEM
                ODMSTATUS result.

           lpszData must be a location that can receive a null-terminated
                octet string exactly as supplied by the ODMA DMS.  The
                area must be null-filled to ensure that null results are
                detected.  No length value is returned.

           dataLen must specify the maximum number of octets that may
                be transferred, including the null-terminator byte.  If
                there is insufficient storage to contain the DMS value,
                the result will be truncated to dataLen-1 octets plus the
                required null-terminator byte, unless dataLen < 1.

           The possible ODMSTATUS values are as follows:

                ODM_SUCCESS  (0) to signify that a result has been supplied

                 ODM_E_FAIL  The operation failed and no predictable result
                             is delivered (although lpszData[] may have been
                             altered)

                 ODM_E_ITEM  No valid propNum was supplied and "\0" string
                             is returned

           Any localization that applies to the delivered strings is what
           the ODMA DMS determined as appropriate.  The prevailing code page
           is presumed to be applicable to the string content, but the
           OdmNative object has not touched the data.

           This method does not implement the full functionality of the ODMA
           ODMGetDocInfo function.  That limitation is by design for
           OdmNative100.
           */


    virtual ODMSTATUS WINAPI
                deriveNewDoc(LPCSTR docFormatName, LPSTR pszDocId) PURE;

        /* This is the initial stage for implementation of the ODMJNI
           transferToNewDocument function.  It is similar in function to
           the first stage of an acceptNewDocument.

           The operation may fail or there may be an user action that causes
           no new document to be established.  The ODMSTATUS will determine
           whether a the new document can be opened for submission of
           content or not.  These determinations and the next actions are
           determined by the application wrapper and not OdmNative.

           For example, an ODMJNI transferToNewDocument operation would
           use an error status in ODMSTATUS to return an appropriate null
           pending document.  In the case of ODM_SUCCESS, the operation
           should continue with any opening of the document and return of
           an OdmPendingDocument interface.

                docFormatName must be a well-formed .-prefixed file
                              extension for of ODMA Document Format Name.
                              If the parameter is NULL or docFormatName[]
                              is ill-formed, ODM_E_FAIL is returned.

                     pszDocId must be the location of a character array
                              of at least ODM_DOCID_MAX octets.  If
                              the operation succeeds, a null-terminated
                              ODMA Document ID is returned.  This is for
                              the new document.  It is not open to the
                              application until explicitly opened.

           The following ODMSTATUS values can be returned:

                ODM_SUCCESS  (0) to signify that a new Document has been
                             derived from the current DMS Document
                             ready for population with new document content.
                             The pszDocId[] array holds the new Document ID.

                 ODM_E_FAIL  No valid result was obtained.  The content of
                             psZDocId is not predictable.  This failure
                             can be the result of a rejection by the DMS.
                             Depending on circumstances, a commitChanges
                             or a local operation might be appropriate.

               ODM_E_CANCEL  The user has cancelled the operation via
                             interaction with the DMS.  See the precautions
                             to be taken against stuck-cancel failures in
                             release notes and the ODMJNI Guide.

            ODM_E_APPSELECT  The user requests that ODMA not be used for
                             creating a new document and a local operation
                             be performed instead.
           */



    virtual HRESULT WINAPI
                openPendingDoc(  LPCSTR pszDocId,
                                 REFIID rIID,
                                   void **ppIface
                                 )
                             PURE;

        /* If successful, this operation initiates a pending document
           using the ODMA Document ID that is provided.  This is typically
           the Document ID returned from a successful deriveNewDoc request.

           At least IUnknown and IodmPending100 are implemented by this
           object, if the operation succeeds.
           */


    /* ODMJNI OdmWorkingDocument Counterparts in IodmWorking100
     * --------------------------------------------------------
     *
     * The OdmWorkingDocument functions are supported by the following
     * IodmWorking100 method.
     */

    virtual BOOL WINAPI commitChanges(void) PURE;
        /* If viewOnly() is TRUE, this function returns FALSE, with
           no changes.

           Before using this method when viewOnly() is FALSE, first save all
           changes to the file at docLocation() and close the file.

           If commitChanges() returns FALSE when viewOnly() is FALSE, the
           operation failed.  At this point, the docID() and docLocation()
           are unchanged, but docProperties and deriveNewDoc must now be
           considered unpredictable.  It is prudent to offer the application
           user the opportunity to save work locally and close the
           application.

           If commitChanges() returns TRUE, the file at docLocation() has
           been accepted as new content by the ODMA DMS.  At this point,
           docId() and all docProperties values may have changed.  The
           docLocation() will not have changed.
           */


    };  /* IodmWorking100 */



/* 0.04 2007-01-01-12:09 Touch up a prototype to use (void) and add a
        FIXME to the prolog about the refactoring to be done later so that
        the level of abstraction and encapsulation has high integrity and
        no complex preconditions between methods.

   0.03 2006-12-30-14:00 Split out the factory definition and devote this
        header to definition of the public interface only. Make touch-ups
        noted in code review up to this point.

   0.02 2006-12-29-16:56 Add changes to reflect clarification of the model
        and other adjustments noticed during review.

   0.01 2006-12-22-08:36 Complete the interface methods needed for the
        transferToNewDocument ODMJNI case and for the commitChanges case.
        Add the OdmBindWorking100 function as the factory for an implementa-
        tion of IodmWorking100.

   0.00 2006-12-21-18:53 Using the basic model of OdmNative100 0.20, develop
        an interface and construction method for OdmWorking100, the Native
        implementation that supports the ODMJNI OdmViewingDocument and
        OdmWorkingDocument approach.  It is not determined at this point
        whether OdmPendingDocument support is simply a different interface
        or an entirely different object that generates one of these.
   */

#endif ODMWORKING100_H
/* $Header: /ODMdev/info/odma/OdmNative100/OdmWorking100.hpp 5     07-01-01 12:13 Orcmid $
   */
/*                     *** end of OdmWorking100.hpp ***                  */
