@echo off
rem BuildClasses.bat 0.01            UTF-8                    dh:2007-01-08
ECHO **   BuildClasses.bat 0.01 COMPILING odmjni100 CLASSES
ECHO **       Compile all of the Java classes needed for odmjni100.

IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildClasses.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST OdmJniBind.java GOTO :FAIL1

erase *.class
rem     Clean out all classes so that build remakes all dependencies.
SET ERRORLEVEL=
rem     Use all ODMJNI packages and compile everything needed for
rem     OdmJniBind.java
javac -cp "$CLASSPATH;%OdmClasses%" OdmJniBind.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   odmjni100 CLASSES COMPILED
ECHO **   **************************
echo:
echo:     There are no errors or warnings.  These classes can be
echo:     used and deployed where they are constructed.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildClasses.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available in that location.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding BuildClasses.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE OdmJniBind.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildClasses
ECHO **       script.  BuildClasses.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildClasses.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD THE odmjni100 JAVA CLASSES.
rem      All of the classes in this package compile as dependencies from
rem      the OdmJniBind class.

rem 0.01 2007-01-08-23:43 Modify to clean out classes first so that
rem      failed dependent builds will be redone because their precursors
rem      are rebuilt.
rem 0.00 2006-11-28-16:00 customized from the odmjni100 BuildClass01.bat
rem      0.01 and the practical100 BuildAlpha.bat 0.08.

rem $Header: /ODMdev/info/odma/odmjni100/BuildClasses.bat 2     07-01-09 0:06 Orcmid $

rem                     *** end of BuildClass01.bat ***