@echo off
rem BuildCheck03.bat 0.00            UTF-8                    dh:2006-12-18
ECHO **   BuildCheck03.bat 0.00 COMPILING Check03.java odmjni100 TEST
ECHO:         This Java application exercises the basic functions of
ECHO:         of the odmjni100 0.25alpha classes to confirm correct access
ECHO:         to OdmNative interfaces and the ODMA API.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildCheck03.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST Check03.java GOTO :FAIL1

SET ERRORLEVEL=
javac -cp ".;%OdmClasses%" Check03.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   Check03.class COMPILED
ECHO **   **********************
echo:
echo:     There are no errors or warnings.  This program can be run
echo:     via RunCheck03.bat.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildCheck03.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your Check03 configuration and ensure that the
ECHO **       directory holding BuildCheck03.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE Check03.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildCheck03
ECHO **       script.  BuildCheck03 has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildCheck03 into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA CLASS TO CONFIRM BASIC odmjni100 INTEGRATION
rem     Confirm basic cases of odmjni100 operation, using OdmJniBind to
rem     exercise the basic setup and confirm operation through to the
rem     ODMA Connection Manager.

rem 0.00 2006-12-18-14:45 Customize from BuildSetup02.bat version of
rem      2006-11-28-19:05.  This build is for the development of Check03
rem      from 0.25alpha to 0.30alpha and perhaps beyond.

rem $Header: /ODMdev/info/odma/odmjni100/test/Check03/BuildCheck03.bat 3     06-12-18 14:50 Orcmid $

rem                     *** end of BuildCheck03.bat ***