/* OdmNullCache.java 0.02            UTF-8                  dh:2006-12-18
 *
 * OdmNullCache implements the OdmNull interface by creating an automatic
 * cache of the six cases.  No case is constructed until it is requested.
 * Thereafter, the same implementation is delivered repeatedly.  None of
 * these implementations hold resources or change anything on a release()
 *
 * There are three flavors of null implementation for any class of
 * OdmDocument implementation:
 *
 *      0 Failed with false returned by all of operationSucceeded(),
 *        operationCancelled(), and localOperationRequested()
 *
 *      1 with only operationCancelled() returning true
 *
 *      2 with only localOperationRequested() returning true
 *
 * These parameters to the Null Document constructors will return the
 * appropriate null behavior.
 */



package info.odma.practical100;

class OdmNullCache implements OdmNull
{

    /* Instance Variables and Constructor
     * ----------------------------------
       */

    private OdmPendingDocument pendingFail;
        /* interface to a null Pending Document in failed state */

    private OdmPendingDocument pendingCancel;
        /* interface to a null Pending Document in cancel state */

    private OdmPendingDocument pendingLocal;
        /* interface to a null Pending Document implementation in
           localOperationRequested state
           */

    private OdmWorkingDocument workingFail;
        /* interface to a null Working Document in failed state */

    private OdmWorkingDocument workingCancel;
        /* interface to a null Working Document in cancel state */

    private OdmWorkingDocument workingLocal;
        /* interface to a null Working Document implementation in
           localOperationRequested state
           */

    OdmNullCache()
    {   /* Clear the cache for filling as needed */

        pendingFail = null;
        pendingCancel = null;
        pendingLocal = null;

        workingFail = null;
        workingCancel = null;
        workingLocal = null;

        } /* OdmNullCache */


    /* Null-Behavior Document Delivery
     * -------------------------------
     *
     * These methods construct and cache the null-behavior document
     * interface implementations.  They are used to avoid excessive
     * class creation and destruction for trivial cases, including when
     * there is no access to ODMA or there is no default DMS.
     *
     * XXX: Constructor recursion is prevented by two techniques.
     *      1. These instantiations do not occur on demand and
               not in any constructor (generally).
            2. No null-document implementation delivers a null-
               document from any of its methods.  Those that would
               do so for a non-null document throw an unchecked
               OdmError exception for the null-document case.
     */


    public final OdmPendingDocument pendingFailed()
    {
        if (pendingFail == null)
             pendingFail = new OdmNullPendingDocument(0);

        return pendingFail;

        } /* pendingFailed */


    public final OdmPendingDocument pendingCancelled()
    {
        if (pendingCancel == null)
             pendingCancel = new OdmNullPendingDocument(1);

        return pendingCancel;

        } /* pendingCancelled */


    public final OdmPendingDocument pendingLocalOperation()
    {
        if (pendingLocal == null)
             pendingLocal = new OdmNullPendingDocument(2);

        return pendingLocal;

        } /* pendingLocalOperation */


    public final OdmWorkingDocument workingFailed()
    {
        if (workingFail == null)
             workingFail = new OdmNullWorkingDocument(0);

        return workingFail;

        } /* workingFailed */


    public final OdmWorkingDocument workingCancelled()
    {
        if (workingCancel == null)
             workingCancel = new OdmNullWorkingDocument(1);

        return workingCancel;

        } /* workingCancelled */


    public final OdmWorkingDocument workingLocalOperation()
    {
        if (workingLocal == null)
             workingLocal = new OdmNullWorkingDocument(2);

        return workingLocal;

        } /* workingLocalOperation */



    } /* OdmNullCache */


/* 0.02 2006-12-18-21:07 Corrections for clean compile
   0.01 2006-12-18-20:43 Make the interface method implementations public
        as required.
   0.00 2006-12-18-20:16 Extract the implementations from the 0.08 version
        of OdmNullConnection and decorate as implementations of OdmNull.

   $Header: /ODMdev/info/odma/practical100/OdmNullCache.java 3     06-12-18 21:10 Orcmid $
   */

/*       *** end of info.odma.practical100.OdmNullCache.java ***        */