/* OdmPendingDocument.java 0.03      UTF-8                  dh:2006-12-17
 *
 * An OdmPendingDocument interface is returned in response to requests
 * for creating a new ODMA DMS managed document.  The OdmDocument methods
 * must be used to determine whether the request is successful.  If so,
 * the docSubmissionLocation() and the commitContent() methods are used
 * to save a document file where the DMS can find it and to inform the
 * DMS, via ODMJNI, that the file is available.
 */

package info.odma.practical100;

public interface OdmPendingDocument extends OdmDocument
{   /* corresponding to a new document that the ODMA DMS is prepared to
       create for the application.  If the operation that delivers this
       interface is unsuccessful, operationSucceeded() will be false and
       there will be a null response for these functions.  Details of the
       unsuccessful condition can be determined by checking whether one
       of OdmPendingDocument.operationCancelled and localOperationRequested
       are true.

       This interface should be released once it is no longer needed.
       Release of the interfaces also causes null behavior to be instituted
       for the following methods.
       */

    java.lang.String docSubmissionLocation();
        /* For a successful request, docSubmissionLocation() is a string
           providing the full path of of a file location that is accessible
           to the application.

           To create the document, the application must open the given
           file location for writing, store the document content in the
           file, and then close the file.

           Once a commitContent() operation has been performed, whether or
           not successful, this operation produces its null response.

               Null response: null

           */

    OdmWorkingDocument commitContent()
                            throws OdmError;
        /* After the document-file content for the new DMS document has been
           saved at the docSubmissionLocation, this operation is performed
           to turn over the material to the DMS.  The creation of the
           initial document is then complete.

           If OdmPendingDocument.operationSucceeded() is true and no
           commitContent() is performed prior to release of this interface,
           no content will be established for this document and anything at
           the docSubmissionLocation may be deleted by ODMA or the DMS.
           Whether there is an "empty document" in the DMS depends on the
           particular DMS implementation.

           Any commitContent() after the first will provoke the null
           response.

           If commitContent() returns a result, it will be a document
           interface that represents the result.  It should be used exactly
           as any OdmWorkingDocument.  If the operation succeeded, the
           interface represents the initialized document that has been
           created at the DMS.

               Null behavior: an unchecked OdmError exception is thrown.
           */

    } /* OdmPendingDocument */


/* 0.03 2006-12-17-14:14 Introduce revised failure modes and expand on the
        release behavior for a pending document.
   0.02 2006-12-14-21:31 Customize for 0.30alpha with cleanup of comments
        and addition of the commitContent() method.
   0.01 2006-10-22-16:50 Customize for 0.05alpha and obtain clean compile.
   0.00 2006-10-20-17:02 Derive New Class from the 0.01alpha Document
        interface.

   $Header: /ODMdev/info/odma/practical100/OdmPendingDocument.java 4     06-12-17 14:35 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmPendingDocument.java ***    */