/* OdmWorkingDocument.java 0.07      UTF-8                   dh:2006-12-17
 *
 * An OdmWorkingDocument interface results from any operation that requests
 * access to an existing ODMA DMS managed document.  Interface methods must
 * be used to determine whether or not there is a document available and
 * what further operations are appropriate.
 *
 * OdmWorkingDocument extends OdmViewingDocument.  In the case that
 * OdmWorkingDocument.viewOnly() is true, only the OdmViewingDocument
 * operations are meaningful.  The additional OdmWorkingDocument methods
 * present null behavior.
 *
 * If OdmWorkingDocument.operationSucceeded() is false, the additional
 * OdmWorkingDocument methods also present null behavior.
 */

package info.odma.practical100;

public interface OdmWorkingDocument extends OdmViewingDocument
{   /* corresponds to an existing managed DMS document.  If a document
       was successfully accessed, this interface provides for returning
       changes to be reflected in the DMS when changes are permitted.
       */

    boolean commitChanges()
                throws OdmError;
        /* This operation is used to deliver changes saved to the file
           at OdmWorkingDocument.documentLocation().  The changes must
           be saved and the file closed before requesting this operation.
           The content should not be discarded from the application until
           it is known that the commitChanges() succeeded.

           If OdmWorkingDocument.operationSucceeded() is false, this
           an unchecked OdmError exception is thrown.  This operation is
           not permitted when there is no actual document being represented
           by the interface.

           commitChanges() returns true when the operation succeeded.  It
           returns false when viewOnly() is true or there is failure for
           some other reason.

           If commitChanges() returns false, the application should
           treat the response as if localOperationRequested() were true,
           providing the user an opportunity to save work in some other way.

           If the commitChanges() succeeds, the OdmWorking document
           interface specifies the characteristics that now apply to the
           document.  All of the OdmViewingDocument information must be
           assumed to have changed, including docID(), docLocation(),
           windowTitle(), and the descriptive document information.

           If an OdmWorkingDocument interface is released and there has
           never been a commitChanges() operation, the DMS document is
           unchanged, regardless of anything that has been done using the
           OdmWorkingDocument.docLocation().


               Null behavior: throws OdmError with indication that the
                              operation is not permissable with a null
                              document.
           */

    } /* odmWorkingDocument */


/* 0.07 2006-12-17-20:20 Corrections to get clean compile in BuildClasses
   0.06 2006-12-17-15:17 Adjust null behavior, failure modes, and emphasize
        the consequences of release without committing changes.
   0.05 2006-12-14-14:02 Modify to extend OdmViewingDocument and add the
        commitChanges method.
   0.04 2006-10-22-20:39 Make the interface public.
   0.03 2006-10-22-16:53 Clean up comments for better explanation of how
        OdmWorkingDocument is created and what data is stable when.
   0.02 2006-10-22-16:27 provide clean compile sufficient for 0.05alpha.
   0.01 2006-10-22-15:59 rename as OdmWorkingDocument and extend the
        new OdmDocument intermediate interface.  Treat as separate from
        the OdmPendingDocument interface which is now being added
   0.00 2006-10-18-22:38 alpha-level version for the first evolutionary
        prototype of ODMJNI components.  This interface is intended to
        become stable very quickly during early testing and application
        integration.

   $Header: /ODMdev/info/odma/practical100/OdmWorkingDocument.java 10    06-12-17 20:27 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmWorkingDocument.java ***    */