/* OdmNullConnection.java 0.09       UTF-8                   dh:2006-12-18
 *
 * The OdmNullConnection class implements null behavior only.  There is no
 * connection, no default DMS, and all operations provide their null
 * behavior.  Instantiations are generally used solely by their interfaces,
 * as in the deprecated
 *
 *      OdmConnection myConnection = new OdmNullConnection("MyAppId");
 *
 * or the recommended form,
 *
 *      OdmConnection myConnection = OdmNullBind.application("MyAppId");
 *
 *
 * This class is useful for regression testing an application for correct
 * implementation of null connection situations.
 *
 * If the application has provision for suppressing ODMA-aware behavior
 * as a configuration option, using this class allows all ODMA-aware code
 * of the application to remain unchanged.  The null connection will
 * automatically cause the correct non-ODMA behavior.
 *
 * This class has minimal resource requirements and there should be
 * no noticeable overhead when it is used to avoid ODMA-aware behavior
 * as an user's configuration choice.
 *
 * Finally, the ODMJNI classes that detect and operate with actual
 * connections to the ODMA Connection Manager are created by extending
 * this class, with the null behaviors obtained from the super-class
 * implementations.
 */


package info.odma.practical100;

public class OdmNullConnection implements OdmConnection
{
    /* Instance Variables and Constructor
     * ----------------------------------
     *
     * To avoid unnecessary construction of classes for null behaviors,
     * the OdmNullConnection class holds a cache of null behaviors that
     * other implementations can use for their error conditions.  The
     * overall-effect is that result codes delivered in other kinds of
     * programming models are essentially "constant" class instances
     * in the ODMJNI handling of failure modes.
     *
     * Because none of these null cases are instantiated until there is
     * a request for it, we also minimize the work of the constructor and
     * take some load off of application startup.
     *
     */


    protected final java.lang.String odmAppId;
        /* The validated Application ID string available to
           subclasses as needed. */

    protected final OdmNull nullDocument;
        /* Initialized in the constructor to hold the cache for null-
           document behaviors. */


    public OdmNullConnection(java.lang.String AppId)
                throws OdmError

    {
        nullDocument = new OdmNullCache();
            /* All that is needed here.  It is shared with non-null
               OdmConnection implementations and can also be shared with
               the document instances that they construct.
               */

        odmAppId = AppId;
            /*FIXME The validation of Application ID strings should
                be implemented, and an unchecked exception thrown, even
                in the null connection implementation.  When functioning
                implementations are developed as subclasses of this one,
                it is this constructor that does the validation work.
                */

        } /* OdmNullConnection */


    /* OdmInterface Interface Method Implementations
     * ---------------------------------------------
     */

    public java.lang.String interfaceImplementation()
    {   /* Return a text string describing this implementation */

        return
            "ODMJNI 1.0 OdmNullConnection 0.09";

        }


    public boolean available()
    {   /* There is no connection available.
           */

        return false;
        }


    public void release()
    {   /* There are no resources that require release. The cache of
           null-behavior document interfaces is kept in operation until
           finalize handles it.  The null methods here are also unchanged
           after a release.
           */

        return;
        }


    /* OdmConnection Interface Method Implementations
     * ----------------------------------------------
     */

    public boolean dmsDefaultAvailable()
    {   /* There is no default DMS available. */

        return false;
        }


    public OdmPendingDocument acceptNewDocument(java.lang.String docFormat)
                              throws OdmError

    {   /* The operation must fail with a null pending document
           that specifies local operation */

        return nullDocument.pendingLocalOperation();

        /* FIXME.  The standard validation of ODMA Document Format
           Names should be performed even in the case of a null
           connection.  The unchecked exception is promised as a
           standard behavior.
           */
        }


    public OdmWorkingDocument chooseDocument()
    {   /* The operation must fail with a null working document
           that specifies local operation */

        return nullDocument.workingLocalOperation();
        }


    public OdmWorkingDocument openKnownDocument(java.lang.String docID)
                              throws OdmError

    {   /* This operation must also fail with a null working document,
           one that specifies failed operation. */

        return nullDocument.workingFailed();

        /* FIXME.  The standard validation of ODMA Document IDs should
           be performed even in the case of a null connection.  The
           unchecked exception is promised as a standard behavior.
           */
        }


    } /* OdmNullConnection */


/* 0.09 2006-12-18-20:48 Factor out the null-document cache implementation
        and use the extracted material to make the OdmNull interface and
        the OdmNullCache implementation.
   0.08 2006-12-17-20:11 corrections to get clean compile
   0.07 2006-12-17-17:36 Adjust the handing of failure modes and null-on-
        null behaviors to reflect the final state navigation model.
   0.06 2006-12-16-22:25 Correct a method capitalization and add caveat
        about how the null document instances must all surrender their
        reference to the OdmNullConnection instance in their constructors,
        which will not be attempted until the OdmNullConnection constructor
        has completed.
   0.05 2006-12-16-12:03 Complete updated null methods for all of the
        OdmConnection operations.
   0.04 2006-12-15-17:30 Transform to the form required for 0.30beta,
        with improved caching of the flavors of null documents that any
        connection and document implementations may want to rely on.
   0.03 2006-11-30-00:26 Make nullPending and nullWorking protected so that
        they can be used by subclasses of OdmNullConnection in odmjni100.
   0.02 2006-10-23-14:52 Remove the cyclic dependencies with OdmNullDocument
        instances, since we don't need it.
   0.01 2006-10-22-23:43 Make all methods public.
   0.00 2006-10-22-21:05 alpha-level version for the first evolutionary
        prototype of the OdmNullConnection implementation.  This class will
        be maintained consistent with the OdmConnection interface and its
        null behaviors as the prototype package is evolved.

   $Header: /ODMdev/info/odma/practical100/OdmNullConnection.java 10    06-12-18 20:58 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmNullConnection.java ***     */