@echo off
rem BuildLib.bat 0.00                UTF-8                    dh:2006-12-31
ECHO ***  BuildLib.bat 0.00 CONSTRUCT OdmNative100.lib FOR STATIC USE

IF NOT EXIST OdmPSDK.bat GOTO :FAIL0
CALL OdmPSDK.bat
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO *** BuildLib.bat ABORTED.  SEE OdmPSDK.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST OdmNative100.obj GOTO :FAIL1
IF NOT EXIST OdmWorking100.obj GOTO :FAIL1

SET ERRORLEVEL=
lib OdmNative100.obj OdmWorking100.obj
rem     Simplest kind of library there is to build
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo ***  OdmNative100.lib CONSTRUCTED SUCCESSFULLY
echo ***  *****************************************
echo:
echo:     There are no errors or warnings.  This .lib is included directly
echo:     in builds of other programs and in odmjni100.dll construction.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO ***  EXECUTE BuildLib.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO ***      The OdmPSDK.bat script must be available in the same place.
ECHO ***      Verify your OdmNative100 configuration and ensure that the
ECHO ***      directory holding BuildOmdNative100.bat is the current working
ECHO ***      directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO ***  BOTH OdmNative100.obj AND OdmWorking.obj MUST BE PRESENT IN THE
ECHO ***      CURRENT DIRECTORY.  BuildLib.bat aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo ***  ERRORS OR WARNINGS IN LIB BUILD, ERRORLEVEL = %ERRORLEVEL% ****
echo ***      To capture a log, run with redirection to a file or pipe the
echo ***      result of BuildLib.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD THE OdmNative100.lib FOR STATIC LINKING.

rem 0.00 2006-12-31-23:27 Customize from BuildNative100.bat 0.03

rem $Header: /ODMdev/info/odma/OdmNative100/BuildLib.bat 2     06-12-31 23:34 Orcmid $

rem                        *** end of BuildLib.bat ***