/* OdmBindWorking100.hpp 0.00        UTF-8                   dh:2006-12-30
 *
 *                       OdmWorking100 FACTORY FUNCTION
 *                       ******************************
 *
 * This header file defines the entry to the OdmBindWorking100 factory
 * function for implementation of the IodmWorking100 interface.  This is
 * used privately among the OdmNative object implementations and is not
 * needed to use the public OdmNative interfaces.
 *
 *                         Copyright © 2006 NuovoDoc
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source files that include this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 */

#ifndef ODMBINDWORKING100_H
#define ODMBINDWORKING100_H


#ifndef __cplusplus
#error  OdmBindWorking100 ENTRY REQUIRES C++.  DON'T USE WITH C.
    /* XXX: We might fix this some day, but not now. */
#endif

#include <windows.h>


/*                       Define OdmBindWorking100 Entry
                         ****************************** */


HRESULT WINAPI
    OdmBindWorking100(   void *pIodmApp, /* Reference to an IodmApplication
                                           interface */
                       LPCSTR pszDocId,  /* ODMA Document ID of the document
                                            to be opened as the working
                                            document. */

                       LPCSTR pszDocLoc, /* ODMA Document Location for the
                                            content file delivered by the
                                            DMS for use by the application.
                                            */

                         BOOL viewMode,  /* True for viewOnly result. */

                       REFIID rIID,      /* The requested interface */

                         void **ppIface
                                         /* The location to receive the
                                            Interface pointer or NULL */
                       );

        /* OdmBindWorking100 constructs an OdmWorking object that
           is tied to the given IodmApplication interface (which it uses
           for infrastructure functions) and the specific Document ID and
           Document Location.

           The created object supports at least IUnknown and IodmWorking100.
           */


/* 0.00 2006-12-30-13:38 Split this header out from OdmWorking100.hpp 0.02.
        This is only used internally to OdmNative and is not needed to make
        use of OdmNative interfaces and the public factory.
        */

#endif ODMBINDWORKING100_H
/* $Header: /ODMdev/info/odma/OdmNative100/OdmBindWorking100.hpp 1     06-12-30 13:51 Orcmid $
   */

/*                   *** end of OdmBindWOrking100.hpp ***                */
