
/* Odma32api100.h 0.15               UTF-8                    dh:2007-01-12
 *
 * ODMA API ENTRY-POINT POINTER DECLARATIONS FOR ODMA 1.0 APPLICATIONS
 *
 *                      Copyright © 2006-2007 NuovoDoc
 *                 Copyright © 1994, 1995 AIIM International
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source code that includes this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 */

#ifndef ODMA32API100_H
#define ODMA32API100_H

#include <windows.h>
    /* Needed for types in these declarations and for Odma32types100.h
       if that header hasn't been processed already
       */

#include "Odma32types100.h"
    /* The only ODMA Types that the 1.00 Entry-Points Depend upon.
       */

/* DECLARE FUNCTION-POINTER TYPES FOR THE ODMA32 1.00 API
 * ******************************************************
 *
 *  These entries are only those supported by ODMA 1.0.  There are other
 *  entries that can be discovered, but the presumption is that the
 *  application will declare itself to be an ODMA 1.0 application and
 *  no beyond-1.0 features are required for the application to work
 *  successfully.
 *
 *  The descriptions here specify ODMA 1.0-aware behavior that also adjusts
 *  for breaking changes that were introduced in subsequent versions of
 *  ODMA.  See Incident Report X000002: ODMA Codes Missing in Odma.h at
 *  <http://ODMA.info/support/X000002.htm> and FAQtip Q000705: Changes
 *  Between ODMA Versions at <http://odma.info/downloads/Q000705.htm>.
 */


#ifdef __cplusplus
extern "C" {
    /* There are no external entries defined here, but there are other
       elements that might depend on the programming model, so we leave
       this C++ qualifier in.
       */
#endif


/* ODMSTATUS WINAPI ODMRegisterApp(ODMHANDLE FAR *pOdmHandle,
                                   WORD version,
                                   LSTR lpszAppId,
                                   DWORD dwEnvData,
                                   LPVOID pReserved);
   */

typedef ODMSTATUS (WINAPI *pfnODMREGISTERAPP)
                     (  ODMHANDLE *pOdmHandle,  /* set to session handle */
                             WORD version,      /* minimum ODMA version for
                                                   this application, *100 */
                           LPCSTR lpszAppId,    /* Application ID sz text
                                                   not over ODM_APPID_MAX */
                             HWND hWin,         /* handle of the
                                                   application window that
                                                   modal DMS dialogs are to
                                                   associate with.*/
                           LPVOID
                        );
                     /* FAR is irrelevant for Win32.
                        0.02: make lpszAppId a constant string input. */
                     /* FIXME: Check the Connection Manager code and make
                        sure that it creates its own copy.
                        */

    /* If successful, *pOdmHandle is set to the handle that represents
       this application's connection for default DMS and general ODMA 1.0
       requests.

       If the operation is unsuccessful, *pOdmHandle is set to NULL.

       The possible ODMSTATUS values are

               ODM_SUCCESS  *pOdmHandle has the handle for this application
                            to use

               ODM_E_NODMS  There is no default DMS for this Application ID

            ODM_E_CANTINIT  The default DMS failed to initialize

             ODM_E_VERSION  The version requirement could not be satisfied.
                            XXX - It is not clear that this is handled
                            properly.

                      other For ODMA 1.0 applications, all ODMSTATUS values
                            other than ODM_SUCCESS should be treated as
                            ODM_E_NODMS.  That is the practical consequence.
                            Troubleshooting these cases can be handled by
                            recording an ODMA 2.0 Connection Manager log.
       */



/* void WINAPI ODMUnRegisterApp(ODMHANDLE odmHandle);
   */

typedef void (WINAPI *pfnODMUNREGISTERAPP)
                (  ODMHANDLE odmHandle  /* for a valid ODMA session */
                   );

    /* This operation releases the default DMS and the handle back into the
       default Connection Manager instance that was created by a successful
       RegisterApp operation.  The handle is invalid after this operation.
       There is no ODMSTATUS and there are no error cases.
       */



/* ODMSTATUS WINAPI ODMSelectDoc(ODMHANDLE odmHandle,
                                 LPSTR lpszDocId,
                                 LPDWORD pdwFlags);
   */

typedef ODMSTATUS (WINAPI *pfnODMSELECTDOC)
                     (  ODMHANDLE odmHandle, /* for a valid ODMA session */
                            LPSTR lpszDocId, /* for the returned Doc ID,
                                                not over ODM_DOCID_MAX */
                          LPDWORD pFlags     /* in-out flags specifying
                                                options and variations */
                        );

    /* This operation invites the default DMS to choose a document for
       the application, performing the appropriate user interactions to
       arrive at a selection.  In an ODMA-aware application that has
       successfully obtained an odmHandle, this operation is to be offered
       prior to presenting the application's build-in file-open dialog,
       unless that dialog has provisions for requesting use of ODMA for
       the document selection.

       The DMS-provided document-selection dialog must always provide
       options that lead to the ODM_E_APPSELECT and ODM_E_CANCEL responses.

       If successful, an ODMA Document ID is stored in lpszDocId[] and
       *pFlags is updated with additional information.

       If unsuccessful, the contents of lpszDocId[] are unpredictable.  The
       *pFlags setting is also unpredictable.

       On input, *pFlags can be 0 or ODM_SILENT.  (It is unusual for a DMS
       to have a silent behavior for selecting documents.  An ODM_E_USERINT
       ODMSTATUS response is likely in that case.)

       The possible ODMSTATUS values are

               ODM_SUCCESS  The Document ID of the User's selection is
                            stored in lpszDocId[] and *flags have been
                            updated with a recommendation on how the
                            document is to be viewed.

              ODM_E_CANCEL  The user closed/cancelled the request.  It is
                            appropriate to treat this response as a
                            cancellation of the user-selected operation
                            rather than treat the same as ODM_E_APPSELECT.
                            [NOTE: A "stuck" ODM_E_CANCEL response can lead
                            to the inability to open any document in the
                            application.  If the user repeats the operation
                            that leads to an already-cancelled request, it
                            may be important to treat another ODM_E_CANCEL
                            as ODM_E_APPSELECT to avoid denying the user
                            an opportunity to do something else.]

           ODM_E_APPSELECT  No choice was made with the DMS.  The user
                            requests that the application's non-ODMA dialog
                            and operations be provided instead.

             ODM_E_USERINT  The DMS requires user interaction for this
                            function.  No operation was performed because
                            *pFlags option ODM_SILENT was specified.

              ODM_E_HANDLE  The OdmHandle parameter is invalid.  This
                            indicates an application error.  There is no
                            meaningful recovery.  It is appropriate to
                            treat this case as an ODM_E_APPSELECT, perhaps
                            with an error indication.  If there is an event
                            log, this situation should be logged to support
                            trouble-shooting as well.

            ODM_E_OTHERAPP  The user used the DMS to select a document in
                            another application.  This response should be
                            treated the same as ODM_E_CANCEL. [NOTE: See the
                            ODM_E_CANCEL note for appropriate behavior when
                            a stuck "ODM_E_OTHERAPP" is suspected.]

                     other  For ODMA 1.0 applications, all ODMSTATUS values
                            other than those listed should be treated as if
                            ODM_E_FAIL had occurred.  (ODM_E_FAIL is defined
                            as a possible ODMRESULT for ODMSelectDoc in ODMA
                            2.0.)  It is recommended that ODM_E_FAIL be
                            treated the same as ODM_E_APPSELECT so the user
                            has a way to continue, with a possible error
                            indication and logging of the event.

       The *pFlags value may have one of these bits set:

            ODM_MODIFYMODE  The selected document should be opened for
                            modification (the default).

              ODM_VIEWMODE  The selected document should be opened for
                            viewing only.

                     other  bits in the flag word should be ignored.

       If no *pFlags bits are set, ODM_MODIFYMODE should be presumed.  If
       both bits are set, take ODM_VIEWMODE as the safe assumption.
       */



/* ODMSTATUS WINAPI ODMGetDocInfo(ODMHANDLE odmHandle,
                                      LPSTR lpszDocId,
                                       WORD item,
                                      LPSTR lpszData,
                                       WORD dataLen);
   */

typedef ODMSTATUS (WINAPI *pfnODMGETDOCINFO)
                     (  ODMHANDLE odmHandle, /* for a valid ODMA session */
                           LPCSTR lpszDocId, /* for a known Document ID */
                             WORD item,      /* code for the Document
                                                item to be retrieved */
                            LPSTR lpszData,  /* address of a buffer to
                                                receive any returned value
                                                (also used as an input
                                                for item ODM_DMS_DEFINED)
                                                */
                             WORD dataLen    /* size, in octets, of the
                                                lpszData[] data buffer */

                         );

    /* This operation requests special values about a document from the
       DMS that holds it.  The document need not be open and it can be held
       by any ODMA DMS that is accessible to the application.

       Changes in status of a document can lead to changes in these item
       values.  In particular, if the document has been opened, a successful
       OdmSaveDoc or OdmCloseDoc may change some or all of the information
       about the document and different items may be available.


               odmHandle  must be a valid handle for a currently-active
                          ODMA Connection Manager session.

               lpszDocId  must be a properly-formed ODMA Document ID.

                    item  is a numeric value that specifies the information
                          being requested:

                          ODM_AUTHOR for the DMS-carried name of the author

                            ODM_NAME for the DMS-carried name of the
                                     document

                            ODM_TYPE for the DMS-recorded type of the
                                     document, related to the nature of
                                     the content, not the digital format

                          ODM_TITLETEXT to be displayed in the title bar
                                     when presenting the content for the
                                     document (meaningful when opened)

                          ODM_CONTENTFORMAT is ODMA Document Format Name
                                     used by the DMS for the content of
                                     this document.  It can be in any
                                     of the forms that have been defined for
                                     use with ODMA

                          ODM_DMS_DEFINED indicating that lpszData[] holds
                                     a text string that names a DMS-specific
                                     item.  The item definition is obtained
                                     by means not specified by ODMA.

                               other additional items have been defined for
                                     versions of ODMA beyond 1.0.  These
                                     should not be used by an application
                                     that claims to require only ODMA 1.0
                                     functions.  The treatment of such
                                     items is undefined.

                lpszData  is the location at which a '\0'-terminated text
                          string will be delivered.  For the ODM_DMS_DEFINED
                          item, it is also where the name of the item is
                          provided.

                 dataLen  is the size of the sessionData block, if one
                          is provided.


       The possible ODMSTATUS values are

               ODM_SUCCESS  (0) The item has been successfully retrieved.
                            Items that do not fit in dataLen octets (with
                            the terminating '\0') will be truncated so that
                            they do fit and end with an '\0'.

               ODM_E_DOCID  The document and/or the DMS that created the
                            Document ID cannot be located.  The DocId might
                            also be ill-formed.

                ODM_E_ITEM  The item number is invalid or not supported by
                            the DMS

              ODM_E_HANDLE  The odmHandle parameter is invalid.  This
                            indicates an application error.  There is no
                            meaningful recovery.  It is appropriate to
                            treat this case as an ODM_E_FAIL, perhaps
                            with an error indication.  If there is an event
                            log, this situation should be logged to support
                            trouble-shooting as well.
                               XXX: Although this is a defined result, it is
                            almost impossible to determine an invalid handle
                            in the current implementations of the ODMA
                            Connection Manager.  It is possible to detect
                            and reject a NULL odmHandle, and future versions
                            of the Connection Manager may also deflect other
                            cases.

                     other  For ODMA 1.0 applications, all ODMSTATUS values
                            other than those listed should be treated as if
                            ODM_E_FAIL had occurred.  The only possible
                            recovery is to attempt the request with a larger
                            buffer in case the DMS is attempting to deliver
                            a lengthy result that can't be truncated.  It is
                            best to offer over-generous buffers instead so
                            there can be no doubt that re-attempt is futile.
       */



/* ODMSTATUS WINAPI ODMOpenDoc(ODMHANDLE odmHandle,
                                   DWORD flags,
                                   LPSTR lpszDocId,
                                   LPSTR lpszDocLocation);
   */

typedef ODMSTATUS (WINAPI *pfnODMOPENDOC)
                     (  ODMHANDLE odmHandle, /* for a valid ODMA session */
                            DWORD flags,     /* flags for the open. */
                           LPCSTR lpszDocId, /* for the document to be
                                                opened to this session. */
                            LPSTR lpszDocLocation
                                             /* for return of the file-
                                                system location to use in
                                                communicating the document
                                                file between app and DMS. */
                        );

    /* ***DOCUMENT ME *** */
    /* ****************** */



/* ODMSTATUS WINAPI ODMSaveDoc(ODMHANDLE odmHandle,
                                   LPSTR lpszDocId,
                                   LPSTR lpszNewDocId);
   */

typedef ODMSTATUS (WINAPI *pfnODMSAVEDOC)
                     (  ODMHANDLE odmHandle, /* for a valid ODMA session */
                           LPCSTR lpszDocId, /* Open Document whose document
                                                file is to be saved from the
                                                associated docLocation. */
                            LPSTR lpszNewDocId
                                             /* The new Document ID to be
                                                used for the document-as-
                                                saved.  It remains open and
                                                the docLocation is still
                                                associated with it. */
                        );

    /* This operation saves any changed content for a document that was
       previously opened by an ODMOpenDoc operation.  Any new content
       must be saved to the docLocation file and that file must be closed.
       The DMS will transfer the content to a DMS-managed location and
       preserve it there.

       If ODMSaveDoc succeeds, the DMS always returns the ODMA Document ID
       that must now be used to refer to the document.  The document with this ID is open and is now associated with the docLocation.

       The lpszNewDocId[] may or may not have the same value as the original
       lpszDocId[].

       The parameters are as follows:

               odmHandle  must be a valid handle for a currently-active
                          ODMA Connection Manager session.  This handle
                          must be the same one by which the OpenDoc and
                          other operations with the specific document
                          were performed.

               lpszDocId  must be the valid ODMA Document ID for the
                          document that was opened for use of its content
                          document file by the application.

            lpszNewDocId  is a buffer of size at least ODM_DOCID_MAX for
                          receiving the '\0'-terminated ODMA Document ID
                          to employ for this saved version of the document


       The possible ODMSTATUS values are

               ODM_SUCCESS  (0) The Document has been successfully closed.

            ODM_E_OPENMODE  This document is not opened in a mode that
                            permits saving of new content.

                ODM_E_FAIL  If the DMS was unable to save the document for
                            some other reason.

              ODM_E_HANDLE  The odmHandle parameter is invalid.  This
                            indicates an application error.  There is no
                            meaningful recovery.  It is appropriate to
                            treat this case as an ODM_E_FAIL, perhaps
                            with an error indication.  If there is an event
                            log, this situation should be logged to support
                            trouble-shooting as well.
                               XXX: Although this is a defined result, it is
                            almost impossible to determine an invalid handle
                            in the current implementations of the ODMA
                            Connection Manager.  It is possible to detect
                            and reject a NULL odmHandle, and future versions
                            of the Connection Manager may also deflect other
                            cases.

                     other  For ODMA 1.0 applications, all ODMSTATUS values
                            other than those listed should be treated as if
                            ODM_E_FAIL had occurred.  Assuming that the
                            request is not made in error, it may be
                            important to offer the user another way to save
                            any changes that have been made so that no work
                            is lost.
       */




/* ODMSTATUS WINAPI ODMCloseDoc(ODMHANDLE odmHandle,
                                    LPSTR lpszDocId,
                                    DWORD activeTime,
                                    DWORD pagesPrinted,
                                   LPVOID sessionData,
                                     WORD dataLen);
   */

typedef ODMSTATUS (WINAPI *pfnODMCLOSEDOC)
                     (  ODMHANDLE odmHandle, /* for a valid ODMA session */
                           LPCSTR lpszDocId, /* Open Document which is to
                                                be closed, invalidating the
                                                docLocation from OpenDoc. */
                            DWORD activeTime,   /* Duration document open */
                            DWORD pagesPrinted, /* Info. about printing. */
                           LPVOID sessionData,  /* Other app-specific
                                                   session information */
                             WORD dataLen    /* The number of octets in
                                                the sessionData record */
                             );

    /* This operation closes an ODMA Document that was previously opened
       by an ODMOpenDoc operation.  This immediately invalidates the
       docLocation that was provided as part of the successful OpenDoc.  Any
       file at docLocation must have been closed and it should not be
       presumed to be available after the CloseDoc.  The DMS may remove the
       file or otherwise make it inaccessible as a result of this operation.

       The CloseDoc does not cause any document file to be transfered from
       the docLocation back to the custody of the DMS.  That must have been
       accomplished using an OdmSaveDoc operation prior to CloseDoc.  Any
       changes made since will effectively be abandoned.

       The application can provide statistics and custom information for
       retention by the DMS.

       The parameters are as follows:

               odmHandle  must be a valid handle for a currently-active
                          ODMA Connection Manager session.  This handle
                          must be the same one by which the OpenDoc and
                          other operations with the specific document
                          were performed.

               lpszDocId  must be the valid ODMA Document ID for the
                          document that was opened for use of its content
                          document file by the application.

              activeTime  is the time, in seconds, spent editing the
                          document.  A value of 0xFFFFFFFF signifies that
                          the activeTime is not known.

            pagesPrinted  is the number of pages of the document content
                          that were printed by the application.  A value of
                          0xFFFFFFFF signifies that the pagesPrinted is not
                          known.

             sessionData  if present, is the location of a block of dataLen
                          octets that provide additional information for
                          retention and usage by the DMS.  The form and use
                          of sessionData is application specific and the
                          DMS must be customized in some application-
                          specific way in order to make use of the data.
                          NULL is used when no sessionData is provided.

                 dataLen  is the size of the sessionData block, if one
                          is provided.


       The possible ODMSTATUS values are

               ODM_SUCCESS  (0) The Document has been successfully closed.

              ODM_E_NOOPEN  The identified document is not (currently)
                            open in this session and no operation was
                            performed.

              ODM_E_HANDLE  The odmHandle parameter is invalid.  This
                            indicates an application error.  There is no
                            meaningful recovery.  It is appropriate to
                            treat this case as an ODM_E_FAIL, perhaps
                            with an error indication.  If there is an event
                            log, this situation should be logged to support
                            trouble-shooting as well.
                               XXX: Although this is a defined result, it is
                            almost impossible to determine an invalid handle
                            in the current implementations of the ODMA
                            Connection Manager.  It is possible to detect
                            and reject a NULL odmHandle, and future versions
                            of the Connection Manager may also deflect other
                            cases.

                     other  For ODMA 1.0 applications, all ODMSTATUS values
                            other than those listed should be treated as if
                            ODM_E_FAIL had occurred.  (ODM_E_FAIL is defined
                            as a possible ODMRESULT for ODMCloseDoc in ODMA
                            2.0.)  It is not clear that there is any useful
                            action that an application can take in the face
                            of a failed ODMCloseDoc operation.
       */



#if 0

ODMSTATUS WINAPI ODMNewDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
    DWORD dwFlags, LPSTR lpszFormat, LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMSaveAs(ODMHANDLE odmHandle, LPSTR lpszDocId,
    LPSTR lpszNewDocId, LPSTR lpszFormat, ODMSAVEASCALLBACK pcbCallBack,
    LPVOID pInstanceData);




/* Entries not used by OdmNative100 (so far):
   */


ODMSTATUS WINAPI ODMActivate(ODMHANDLE odmHandle, WORD action,
    LPSTR lpszDocId);

ODMSTATUS WINAPI ODMSetDocInfo(ODMHANDLE odmHandle, LPSTR lpszDocId,
    WORD item, LPSTR lpszData);

ODMSTATUS WINAPI ODMGetDMSInfo(ODMHANDLE odmHandle, LPSTR lpszDmsId,
    LPWORD pwVerNo, LPDWORD pdwExtensions);

/* The OdmQueryInterface operation is also an ODMA 1.0 feature.  In current
   Win32 development, <windows.h> defines the necessary elements so there
   is no reason not to provide an entry for it here.
   */

// ODMA 1.5 AND QUERY ENHANCEMENTS
/* The four operations that do not take ODMHANDLE parameters are available
   for discovery and use by ODMA 1.0 applications.  The application must be
   prepared for these entries to be absent in case an ODMA 1.0 Connection
   Manager is present.
   */

WORD WINAPI ODMGetDMSCount();

WORD WINAPI ODMGetDMSList( LPSTR buffer, WORD buffer_size );

ODMSTATUS WINAPI ODMGetDMS( LPCSTR lpszAppId, LPSTR lpszDMSId );

ODMSTATUS WINAPI ODMSetDMS( LPCSTR lpszAppId, LPCSTR lpszDMSId );

ODMSTATUS WINAPI ODMQueryExecute(ODMHANDLE odmHandle, LPCSTR lpszQuery,
                                 DWORD flags, LPCSTR lpszDMSList,
                                 LPSTR queryId );

ODMSTATUS WINAPI ODMQueryGetResults(ODMHANDLE odmHandle, LPCSTR queryId,
                                    LPSTR lpszDocId, LPSTR lpszDocName,
                                    WORD docNameLen,
                                    WORD *docCount );

ODMSTATUS WINAPI ODMQueryClose(ODMHANDLE odmHandle, LPCSTR queryId );

// ODMA 2.0 ENHANCEMENTS

ODMSTATUS WINAPI ODMCloseDocEx(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, DWORD activeTime,
                            DWORD pagesPrinted,
                            LPVOID sessionData, WORD dataLen);

ODMSTATUS WINAPI ODMSaveAsEx(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPSTR lpszNewDocId, LPSTR lpszFormat,
                            ODMSAVEASCALLBACK pcbCallBack,
                            LPVOID pInstanceData, LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMSaveDocEx(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPSTR lpszNewDocId,	LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMSelectDocEx(ODMHANDLE odmHandle, LPSTR lpszDocIds,
                            LPWORD pwDocIdsLen, LPWORD pwDocCount,
                            LPDWORD pdwFlags,
                            LPSTR lpszFormatFilter);

ODMSTATUS WINAPI ODMQueryCapability(ODMHANDLE odmHandle, LPCSTR lpszDmsId,
                            DWORD function, DWORD item, DWORD flags);

ODMSTATUS WINAPI ODMSetDocEvent(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            DWORD flags, DWORD event, LPVOID lpData,
                            DWORD dwDataLen,
                            LPSTR lpszComment);

ODMSTATUS WINAPI ODMGetAlternateContent(ODMHANDLE odmHandle,
                            LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszFormat,
                            LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMSetAlternateContent(ODMHANDLE odmHandle,
                            LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszFormat,
                            LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMGetDocRelation(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszLinkedId,
                            LPSTR lpszFormat,
                            LPSTR lpszPreviousId);

ODMSTATUS WINAPI ODMSetDocRelation(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszLinkedId,
                            LPSTR lpszFormat,
                            LPSTR lpszPreviousId);

#endif  // DEFERRED DECLARATIONS


#ifdef __cplusplus
}
#endif


/* 0.15 2007-01-12-15:02 Add comments to the description for OdmSaveDoc.
        Clean up some other entries.  Make note of the use of some ODMA 1.5
        operations so long as the Connection Manager supports them.  Also,
        ODMQueryInterface should be defined here as an ODMA 1.0 API entry.
   0.14 2006-12-19-16:01 Clean up some broken lines and presentation.  Get
        clean compilation of the header.
   0.13 2006-12-28-13:35 Complete provisional entries for all and only
        those entries used in the ODMJNI and OdmNative implementation for
        now.  Leave others hanging as bypassed definitions until we have
        something to test them with.
   0.12 2006-12-27-22:24 Start provisional function entries required for
        ODMJNI 1.0 0.30alpha.
   0.11 2006-11-25-20:26 Review and adjust for use as part of the 0.20alpha
        OdmNative100 distribution.
   0.10 2006-11-23-18:56 Make HWND parameter to ODMRegisterApp, reflecting
        the Win32 case.
   0.09 2006-11-23-15:00 Correct recommendation for view-case ambiguity
        in the description of ODMSelectDoc.
   0.08 2006-11-22-23:38 Correct indirection in the prototype for
        ODMSelectDoc.
   0.07 2006-11-22-20:07 Complete the annotation of ODMSelectDoc.
   0.06 2006-11-22-18:53 Remove the use of fixed-size char arrays in the
        prototypes.  This doesn't work for LPSTR.
   0.05 2006-11-22-18:19 Switch from Odma.h to dependence on the matching
        Odma32types100.h for Types and Values declarations.
   0.04 2006-11-21-15:47 Change to Odma32api100.h, add an updated copyright
        and license notice, then annotate the entry points that we are
        testing so far.
   0.03 2006-11-02-19:39 Add pfnODMSELECTDOC prototype.
   0.02 2006-11-02-16:12 Use LPCSTR for the AppId string pointer in
        the pfnODMREGISTERAPP prototype.
   0.01 2006-11-01-17:30 Correct type of ODMHANDLE output parameter of
        the ODMRegisterApp entry-point pointer type.
   0.00 2006-11-01-15:23 Define enough cases to confirm default
        DMS Connection.  Put WINAPI decorator inside with the pointer.
        */

#endif // !ODMA32API100_H
/*   $Header: /ODMdev/info/odma/OdmNative100/Odma32api100.h 18    07-01-12 15:11 Orcmid $
   */

/*                       *** end of Odma32api100.h ***                */
