/* Odma32types100.h 0.02             UTF-8                    dh:2006-11-25
 *
 *       ODMA API TYPE AND VALUE DECLARATIONS FOR ODMA 1.0 APPLICATIONS
 *
 *                         Copyright © 2006 NuovoDoc
 *                 Copyright © 1994, 1995 AIIM International
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source code that includes this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 */

#ifndef ODMA32TYPES100_H
#define ODMA32TYPES100_H

/*  FIXME: ADD PRAGMAS AND ERRORS TO CONFIRM THE PLATFORM ASSUMPTIONS.
    */

#include <windows.h>
    /* For the base types used to define ODMA Types and used in the
       ODMA API function signatures.
       */


/*              DECLARE TYPES AND VALUES FOR THE ODMA32 1.00 API
 *              ************************************************
 *
 *  These types and values those supported by ODMA 1.0.  The values are the
 *  only ones that an ODMA-aware application is expecting to use and
 *  recognize when it registers as a 1.0-compatible application.
 *
 *  For the specific use of the values and types in ODMA 1.0 operations,
 *  there is more information with the Odma32api100.h definitions.
 *
 *  The original specification for ODMA 1.0 operations is available on-line
 *  at <http://odma.info/downloads/odma10-2.htm>.  For breaking changes
 *  that were introduced in subsequent versions of ODMA see
 *
 *      Incident Report X000002: ODMA Codes Missing in Odma.h
 *          <http://ODMA.info/support/X000002.htm>
 *
 *      FAQtip Q000705: Changes Between ODMA Versions
 *          <http://odma.info/downloads/Q000705.htm>.
 */

/* Type definitions */
typedef LPVOID ODMHANDLE;
typedef LPSTR (*ODMSAVEASCALLBACK)(DWORD dwEnvData, LPSTR lpszFormat, LPVOID pInstanceData);
typedef int ODMSTATUS;

/* Constants */
#define ODM_API_VERSION         100
    /* Version of the API */
    /* FIXME: Is this appropriate here, and is this the proper name for it?
       */

#define ODM_DOCID_MAX		    255
    /* Win32 */

#define ODM_DMSID_MAX			9
    /* Max length of a DMS ID including the terminating '\0'.  */

#define ODM_APPID_MAX			16
    /* Max length of a application ID including the terminating '\0' */

#define ODM_FORMAT_MAX			81
    /* Maximum length of a format-identification string, including
       the terminating '\0'. */

#define ODM_FILENAME_MAX	255		/* Win32 */
    /* Maximum length of a filename returned by ODMA including the
       terminating '\0'.  This is the Win32 platform-dependent value. */
    /* FIXME: USE THE WIN32 PSDK CONSTANT FOR THIS PARAMETER */

/* COMMON FORMAT IDENTIFICATIONS */

    /* These were made up at the time of ODMA 1.0 and have been retained.
       It is not clear that these are consistent with the current rules
       for format identification.
       FIXME: Figure out how to substitute the preferred identifications
           without invalidating previous use of the current values.  We
           may need to alter the names in some systematic way that avoids
           confusion with uses of the original Odma.h files.
           */

#define ODM_FORMAT_TEXT	"Text"
#define ODM_FORMAT_RTF	"Rich text format"
#define ODM_FORMAT_DCA	"DCA RFT"
    /* IBM DCA Rich Format Text */
#define ODM_FORMAT_TIFF	"Tiff"
#define ODM_FORMAT_GIF	"Gif"
    /* Compuserve Graphics Interchange Format */
#define ODM_FORMAT_BMP	"Windows bitmap"
#define ODM_FORMAT_PCX	"PCX"
#define ODM_FORMAT_CGM	"CGM"
    /* Computer Graphics Metafile */
#define ODM_FORMAT_EXE	"Executable file"
#define ODM_FORMAT_PCL	"PCL"
    /* HP Printer Control Language */
#define ODM_FORMAT_PS	"PostScript"


/* ODMSTATUS VALUES */

#define ODM_SUCCESS			0
    /* This ODMA 2.0 naming is guaranteed
       to be 0 as specified in ODMA 1.0 */
#define ODM_NOERROR         0
    /* Alternative name used in ODMA 1.5 */


#define ODM_E_FAIL			1
    /* Unspecified failure */
#define ODM_E_CANCEL		2
    /* Operation cancelled by user. */

#define ODM_E_NODMS			3
    /* RegisterApp: DMS not registered */
#define ODM_E_CANTINIT		4
    /* RegisterApp: DMS initialize failed */
#define ODM_E_VERSION		5
    /* RegisterApp: DMS/Connection Manager
       doesn't support the requested ODMA
       version or later */

#define ODM_E_APPSELECT		6
    /* User has indicated that the application should use
       it's standard file-system dialog for the requested
       application operation rather than interface with
       the ODMA DMS. */

#define ODM_E_USERINT		7
    /* Requested action cannot be performed
       without user interaction, but silent
       mode was specified. */

#define ODM_E_HANDLE		8
    /* The DMHANDLE argument was invalid. */

#define ODM_E_ACCESS		9
    /* User does not have access rights for
       the requested use of the specified document.
       */

#define ODM_E_INUSE			10
    /* Document is currently in use and cannot
       be accessed in the specified mode. */

#define ODM_E_DOCID			11
    /* Invalid document ID */

#define ODM_E_OPENMODE		12
    /* The specified action is incompatible
       with the mode in which the document was
       opened. */

#define ODM_E_NOOPEN		13
    /* The specified document is not open. */

#define ODM_E_ITEM			14
    /* Invalid item specifier. */

#define ODM_E_OTHERAPP		15
    /* Selected document was for another app. */

#define ODM_E_NOMOREDATA	16
    /* No more data is available */

#define ODM_E_PARTIALSUCCESS 17
    /* Response for a query operation that could not be performed
       by all of the specified ODMA DMSs. */


// Misc. modes, flags

#define ODM_SILENT			16
    /* Don't interact with the user while
       fulfilling this request. */

// ODMOpenDoc modes - flags values.
#define ODM_MODIFYMODE		1
    /* Open document in a modifiable mode. */
#define ODM_VIEWMODE		2
    /* Open document in non-modifiable mode. */

    /* ODMA 2.0 introduced ODM_REFCOPY which was incorrectly given the
       value 3, rather than 4.  This value does not arise in conjunction
       with ODMSelectDoc, however.  The recommended Odma32api100.h treat-
       ment of ambigous *pFlags values as ODM_VIEWMODE is consistent with
       that case as well.
       */



// Actions for ODMActivate
#define ODM_NONE			0
    /* No specific action is requested.  */
#define ODM_DELETE			1
    /* Delete the specified document.  */
#define ODM_SHOWATTRIBUTES	2
    /* Display the specified document's profile
       or attributes. */
#define ODM_EDITATTRIBUTES	3
    /* Edit the specified document's profile or
       attributes. */
#define ODM_VIEWDOC			4
    /* Display the specified document in a
       viewer window. */
#define ODM_OPENDOC			5
    /* Open the specified document in its
       native application.  */

// ODMA 2.0
#define ODM_NEWDOC			6
#define ODM_CHECKOUT		7
#define ODM_CANCELCHECKOUT	8
#define ODM_CHECKIN			9
#define ODM_SHOWHISTORY		10


// Item selectors for ODMGetDocInfo and ODMSetDocInfo
#define ODM_AUTHOR			1
    /* Author of the document. */
#define ODM_NAME			2
    /* Descriptive name of the document.  */
#define ODM_TYPE			3
    /* Type of the document.  */
#define ODM_TITLETEXT		4
    /* Suggested text to display in the
       document window's title bar. */
#define ODM_DMS_DEFINED		5
    /* DMS defined data. */
#define ODM_CONTENTFORMAT	6
    /* String describing document's format */


/* 0.02 2006-11-25-20:49 Customization sufficient for OdmNative100
        0.20alpha release.

   0.01 2006-11-22-19:27 Add ODM_SILENT back in and continue clean-ups and
        annotations.

   0.00 2006-11-22-16:24 Customize Odma.h 200-1 to just the types portion.
        This becomes the initial alpha-test level version to be confirmed
        with the OdmNative100 library.
   */

#endif ODMA32TYPES100_H
/* $Header: /ODMdev/info/odma/OdmNative100/Odma32types100.h 7     06-11-25 20:50 Orcmid $
   */

/*                        *** end of Odma32types100.h ***                */

