/* Check03.java 0.13                 UTF-8                   dh:2007-01-13
 *
 *              DEMONSTRATE THE odmjni100 BASIC NATIVE FUNCTIONS
 *              ************************************************
 *
 * This program relies on info.odma.odmjni100.OdmJniBind methods for
 * confirmation of successful access to the odmjni100.dll.  We only
 * obtain the results that come via OdmJniBind and the interfaces
 * that become available through OdmJniBind.application(appId).
  */

 import info.odma.practical100.*;

 import info.odma.odmjni100.*;

 class Check03
 {  /* PROVIDE OPERATIONAL DEMONSTRATION OF ODMJNI NATIVE ACCESS.
       */


    /* AUXILLIARY OUTPUT PRESENTATION OPERATIONS
       ***************************************** */


    private static final String indent = "         ";
            /* Indent below the          "Check03> ". */

    private static final String stars =  "       **** ";
            /* Used to highlight unexpected results */


    private static void hello(IConOut console)
    {   /* Identify the application and what we are doing here.
           */

        console.println();
        console.println(   "Check03> 0.13 Explore chooseDocument() "
                           + " (using JNI " + OdmJniBind.getVersion()
                           + ")"
                           );

        } /* hello */



    private static void reportInterface(           IConOut  console,
                                          java.lang.String  impText
                                          )

    {   /* Report the interface implementation. */

        console.println();
        console.println(   indent + "> OdmConnection interface acquired:\n"
                         + indent + "  " + impText);

        } /* reportInterface */



    private static void reportConnection(   IConOut console,
                                            boolean hasConnection
                                            )

    {   /* Report whether or not there is a connection available. */

        console.println();

        if(hasConnection)
             {  /* Just report that there is one and we can continue. */
                console.println(indent + "> > "
                                       + "An ODMA Connection is available."
                                       );

                }
        else {  /* Point out that there is nothing more to do. */
                console.println(indent + "> > "
                                       + "No ODMA Connection is available."
                                       );

                console.println(indent + "    "
                                       + "No ODMA Operations can be "
                                       + "performed."
                                       );
                }

        } /* Report Connection */



    private static void reportExpectedNoDefault
                            (  IConOut console,
                               boolean hasDefaultDMS
                               )
    {   /* There should be no default because there is no connection. */

        if (hasDefaultDMS)
             console.println
                 (stars + "FALSE REPORT OF DEFAULT DMS AVAILABLE");
        else console.println(indent + "    "
                                    + "There is no default DMS, "
                                    + "as expected."
                                    );
        } /* reportExpectedNoDefault */


    private static void reportAvailabilityDefaultDMS
                                (  IConOut console,
                                   boolean hasDefaultDMS
                                   )
    {   /* There may or may not be a default DMS. */

        console.println();

        if (hasDefaultDMS)

             {  /* report that we have one and we just continue. */

                console.println(indent + "> > > "
                                       + "A Default DMS is available."
                                       );
                }

        else {  /* report that we don't have one and we can't do much. */

                console.println(indent + "> > > "
                                       + "No Default DMS is available."
                                       );

                console.println(indent + "      "
                                       + "No Default-DMS operations"
                                       + " are possible."
                                       );
                }

        } /* reportAvailabilityDefaultDMS */


    private static void reportChoiceResult
        (                                   IConOut  console,
          info.odma.practical100.OdmWorkingDocument  choice                                   )

    {   /* Describe the document implemented by the interface.
        FIXME: There is a breach of cohesion and coupling here
               by performing operator interaction.  We should
               not be doing that here.  We may also have to
               use an IConIO interface to get it to work at all.
               */

        console.println();
        console.print(indent
                        + "> > > > chooseDocument() = "
                        );
        if (choice == null)
             {  console.println("null.");
                return;
                    /* because there is nothing more to say */
                }
                console.println("an interface-implementation reference:");

        console.println(indent + "        "
                           + choice
                           );
        console.println(indent + "        "
                           + choice.interfaceImplementation()
                           );

        console.println();

        console.println(indent + "        "
                           + "           dmsAvailable() = "
                           + choice.dmsAvailable()
                           );
        console.println(indent + "        "
                           + "     operationSucceeded() = "
                           + choice.operationSucceeded()
                           );
        console.println(indent + "        "
                           + "     operationCancelled() = "
                           + choice.operationCancelled()
                           );
        console.println(indent + "        "
                           + "localOperationRequested() = "
                           + choice.localOperationRequested()
                           );

        console.println();

        showProperties(console, indent + "        ", choice);

        } /* reportChoiceResult */


    private static void showProperties
               (                                     IConOut  console,
                                            java.lang.String  indent,
                   info.odma.practical100.OdmWorkingDocument  choice                                   )
    {
        console.println(indent
                           + "viewOnly() = " + choice.viewOnly()
                           );

        reportStringOrNull(console, indent,
                                    "docID()",
                                    choice.docID() );

        reportStringOrNull(console, indent,
                                    "docLocation()",
                                    choice.docLocation() );

        console.println();

        reportStringOrNull(console, indent,
                                    "windowTitle()",
                                    choice.windowTitle() );

        reportStringOrNull(console, indent,
                                    "dmsAuthor()",
                                    choice.dmsAuthor() );

        reportStringOrNull(console, indent,
                                    "dmsDocName()",
                                    choice.dmsDocName() );

        reportStringOrNull(console, indent,
                                    "dmsDocType()",
                                    choice.dmsDocType() );

        reportStringOrNull(console, indent,
                                    "dmsFormatName()",
                                    choice.dmsFormatName() );

        } /* showProperties */


    private static void reportStringOrNull
                (        IConOut  out,
                 java.lang.String indent,
                 java.lang.String name,
                 java.lang.String value)

    {   /* Show the string value as null or as the text value */

        out.print(indent + name + " = ");
        if (value == null)
             out.println("null");
        else out.println("\n" + indent + "  |"
                              + value + "|");

        } /* reportStringOrNull */



    private static void reportDefaultDrop(  IConOut  console,
                                            boolean  hasDefaultDMS
                                            )
    {   /* If there is a default DMS, report on its release */

        if (!hasDefaultDMS) return;

        console.println();
        console.println(indent
                        + "> > > The Default DMS is no longer required.\n"
                        + indent
                        + "      It is released by OdmConnection.release()."
                        );

        } /* reportDefaultDrop */



    private static void reportConnectionDrop(   IConOut  console,
                                                boolean  hasConnection
                                                )
    {   /* If there is a connection, report on its release */

        if (!hasConnection) return;

        console.println();
        console.println(indent
                        + "> > The Connection is no longer required.\n"
                        + indent
                        + "    It is released by OdmConnection.release()."
                        );

        } /* reportConnectionDrop */



    private static void reportRelease(IConOut console)
    {   /* Simply report that the symmetrical release case
           has happened.
           */

        console.println();
        console.println(indent + "> Interface OdmConnection.release() "
                               + "performed.");
        } /* reportRelease */



    private static void reportDefaultDropped
                            (  IConOut console,
                               boolean nowDefault
                               )
    {   /* Confirm that the default is no longer available. */

        if (!nowDefault)
             console.println(indent + "  The Default DMS is no longer "
                                    + "available."
                                    );

        else console.println(stars + "THE DEFAULT DMS DIDN'T DROP.");

        } /* reportDefaultDropped */



    private static void reportConDropped(  IConOut console,
                                           boolean nowConnected
                                           )
    {   /* Confirm that the connection is no longer available. */

        if (!nowConnected)
             console.println(indent + "  The connection is no longer "
                                    + "available."
                                    );

        else console.println(stars + "THE CONNECTION FAILED TO DROP.");

        } /* reportConDropped */



    private static void goodbye(IConOut console)
    {   /* Announce completion of operation */

        console.println();
        console.println("Check03> exit");
        console.println();
        } /* goodbye */



    private static final IConOut
        stdout = new ConWriter(java.lang.System.out);
                     /* use a default console-output implementation */


    /* THE MAIN PROCEDURE AND ITS SUBORDINATE OPERATIONS
       ************************************************* */


    public static void main(String[] args)
    {   /* Exercise enough of OdmJniBind to confirm that we have
           basic connection and OdmNative access. */

        hello(stdout);

        OdmConnection OdmApp = OdmJniBind.application("OdmNativeTest");

        reportInterface(stdout, OdmApp.interfaceImplementation() );

        boolean haveConnection = OdmApp.available();

        reportConnection(stdout, haveConnection);

        boolean haveDefaultDMS = OdmApp.dmsDefaultAvailable();

        if (!haveConnection)
             {  reportExpectedNoDefault(stdout, haveDefaultDMS);
                haveDefaultDMS = false;
                    /* forcing consistency after possible problem. */
                }

        else reportAvailabilityDefaultDMS(stdout, haveDefaultDMS);

        info.odma.practical100.OdmWorkingDocument choice = null;
            /* reference to result of chooseDocument(), if any.
               */

        if (haveDefaultDMS)
             {  /* Report provisional use of chooseDocument(). */
                choice = OdmApp.chooseDocument();
                reportChoiceResult(stdout, choice);
                }

        boolean proceedOK = (choice != null);

        if (proceedOK)
             proceedOK = choice.operationSucceeded()
                               && !choice.viewOnly();

        if (proceedOK)
            { stdout.println();
              stdout.println(indent + "        "
                                    + "Requesting commitChanges()"
                                    );
              boolean changed = choice.commitChanges();
              stdout.println(indent + "        "
                                    + "commitChanges reports "
                                    + changed
                                    );
              stdout.println();
              showProperties(stdout, indent + "        ", choice);
              }

        if (choice != null)
             choice.release();

        reportDefaultDrop(stdout, haveDefaultDMS);

        reportConnectionDrop(stdout, haveConnection);

        OdmApp.release();
        reportRelease(stdout);
        if (haveDefaultDMS)
             reportDefaultDropped(stdout, OdmApp.dmsDefaultAvailable());
        if (haveConnection)
             reportConDropped(stdout, OdmApp.available());

        goodbye(stdout);

        } /* main */



    } /* Check03 */


/* 0.13 2007-01-13-21:51 Add further logic to exercise commitChanges() in
        the manner of OdmNative test Check05 0.08 for 0.40alpha.
   0.12 2007-01-08-24:00 Be sure to release the document because finalize
        is apparently too late.
   0.11 2007-01-04-21:15 Expand the handling of chooseDocument results:
        Report on the returned interface implementation and document
        properties.
   0.10 2006-12-18-15:08 Make corrections to get clean compile.
   0.09 2006-12-18-15:01 Rename Setup02 to Check03 and customize to use the
        0.30alpha practical100 and 0.25alpha odmjni100.OdmJniBind.
   0.08 2006-11-30-13:22 Introduce provisional use of chooseDocument.
   0.07 2006-11-29-22:17 Add checks and reports on Default DMS availability.
   0.06 2006-11-29-21:13 Correct the sense of the expected boolean
        in reportConDropped.
   0.05 2006-11-29-19:20 Regression build to make sure adding lifecycle
        control of the rIodmNative interface reference in OdmJniApp has
        not changed anything.
   0.04 2006-11-29-17:02 Add report about Connection drop succeeding.
   0.03 2006-11-28-23:41 Report Connection status and dropping too.
   0.02 2006-11-28-22:33 Test the info.odma.odmjni100.OdmJniBind class
        static application("appId") method and demonstrate that it
        returns a null implementation of practical100.OdmConnection.
   0.01 2006-11-28-18:47 Use the public OdmJniBind.getVersion() method
        so we can see use of the native jniVersion method in an useful
        way.
   0.00 2006-11-28-18:04 Strip back Setup01.java 0.06 for building up
        as a Java-based exercise of the basic connection functions of
        odmjni100.

   $Header: /ODMdev/info/odma/odmjni100/test/Check03/Check03.java 14    07-01-13 22:44 Orcmid $
   */

/*                         *** end of Check03.java ***                   */
