@echo off
rem BuildClasses.bat 0.01            UTF-8                    dh:2006-12-17
ECHO **   BuildClasses.bat 0.00 COMPILING practical100 CLASSES
ECHO **       Compile all of thepractical100 Java classes and interfaces

IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildClasses.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST OdmNullConnection.java GOTO :FAIL1

SET ERRORLEVEL=
rem     Compile everything needed for practical100 by compiling
rem     OdmNullConnection and all of its dependencies.
javac -cp "$CLASSPATH;%OdmClasses%" OdmNullBind.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   practical100 CLASSES COMPILED
ECHO **   *****************************
echo:
echo:     There are no errors or warnings.  These classes can be
echo:     used and deployed where they are constructed.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildClasses.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available in that location.
ECHO **       Verify your practical100 configuration and ensure that the
ECHO **       directory holding BuildClasses.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE OdmNullConnection.java FILE IS NOT PRESENT IN THE CURRENT
ECHO **       DIRECTORY.  The file should be in the same directory as this
ECHO **       BuildClasses script.  BuildClasses.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildClasses.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD THE practical100 JAVA CLASSES.
rem      All of the classes in this package compile as dependencies from
rem      the OdmNullConnection class.

rem 0.01 2006-12-17-21:59 change to build from OdmNullBind.java rather
rem      than OdmNullConnection.java.
rem 0.00 2006-12-01-19:29 customize from the odmjni100 BuildClasses.bat
rem      script.

rem $Header: /ODMdev/info/odma/practical100/BuildClasses.bat 4     06-12-17 20:00 Orcmid $

rem                     *** end of BuildClasses.bat ***