/* OdmViewingDocument.java 0.08      UTF-8                   dh:2006-12-17
 *
 * An OdmViewingDocument interface results from any operation that requests
 * access to an existing ODMA DMS managed document.  Interface methods must
 * be used to determine whether or not there is a document available and
 * what further operations are appropriate.
 *
 * The OdmViewingDocument interface provides those behaviors that are usable
 * whether or not OdmViewingDocument.viewOnly() is true.  When extended to
 * have further behaviors (e.g., by OdmWorkingDocument), those extended
 * operations will all have their null behaviors when viewOnly() is true.
 */


package info.odma.practical100;

public interface OdmViewingDocument extends OdmDocument
{   /* corresponds to an existing DMS-managed document.  If the operation
       that delivers this interface is unsuccessful, operationSucceeded()
       will be false and there will be a null response for these functions.
       Otherwise, the original values will persist until a submission of
       changes to the document (e.g., OdmWorkingDocument.commitChanges())
       or there is a release().
       */

    boolean viewOnly();
        /* For a successful document access, viewOnly() returns true when
           any delivered content is not to be returned to the DMS, with or
           without changes.

           When viewOnly() is true, the document is not checked out for
           modification and no changes will be accepted by the DMS.

           When viewOnly() is true, the document should be displayed
           as if it is stored on the file system as a read-only document,
           whether it is or not.

           A view-only document can still be saved as a new document,
           whether in the local file system or to a DMS.  The DMS from which
           the document is retrieved might also permit the equivalent of a
           Save As ... operation in creating a new managed document derived
           from the first but not replacing the first.  (See the
           acceptAsNewDocument operation, below.)

               Null response: false

           XXX: This is the conventional null response for a boolean-valued
               operation.  However, when no document has been accessed, or
               the interface has been released, the result of viewOnly()
               is meaningless.
           */


    java.lang.String docID();
        /* For a successful document access, this method returns a string
           with the ODMA Document ID of the document whose content is
           delivered at docLocation().

           ODMA Document IDs are intended to be opaque identifiers used in
           communication between ODMA-aware applications and ODMA-compliant
           DMS systems.  The ODMA Document ID is not intended to be human
           understandable.  In general, the ODMA Document ID is not to be
           displayed to users, although it may need to be recorded for
           future re-access to the same DMS-managed document.  It may also
           be transmitted in e-mail, stored as a link from another document,
           and provided to applications on their command lines as part of
           an automated application initiation in a workflow or other
           document-management related operation.

           Where possible, the dmsDocName() string is preferable for visible
           display to the user, with the docID restricted to technical
           purposes.

           WARNING: Each time content changes are commited to the DMS,
               docID() may change.

               Null response: null
           */


    java.lang.String docLocation();
        /* For a successful document access, docLocation() is a string
           with the location in the local file system where the ODMA DMS
           has delivered a copy of the DMS-managed document content.

           This is a temporary location and it should not be used as a
           permanent location for the delivered content.  If the document
           file in this location is opened for viewing (viewOnly() is true)
           or for manipulation and possible return to the DMS (viewOnly() is
           false), it must be closed by the application, whether or not
           altered, before this interface is released.  It must also be
           closed before committing the changed file to the ODMA DMS.

           Releasing the interface relinquishes all claims to the
           docLocation() file and the DMS or ODMJNI may delete the file at
           that point.

           WARNING: Each time content changes are commited to the DMS,
               docLocation() may change.


               Null response: null
           */


    java.lang.String windowTitle();
        /* For a successful document access, windowTitle() is an user-
           readable text that is the recommended identification of the
           retrieved document in the title bar of a window in which the
           document-file content is displayed for viewing and/or editing.
           This text is in the localized form delivered by the DMS.

           This text may have been truncated in delivery from the DMS.  It
           is permissable for it to be truncated further as part of display
           presentation.  In making such adjustments and accomodating
           possible changes in size of the display area, it is important to
           avoid splitting a Unicode surrogate pair.  Changes in writing
           direction and other accomodations of international language use
           will depend on whether such sophistication is delivered by the
           DMS.  Generally only simple language text is delivered to ODMA
           from DMS implementations.

           It is valid for there to be a null response even though there has
           been successful document retrieval.

           WARNING: Each time content changes are commited to the DMS,
               windowTitle() may change.


               Null response: null

           */


    java.lang.String dmsAuthor();
        /* For a successful document access, dmsAuthor() is an user-readable
           text that is the name of the document's author as held by the
           DMS.  This name is in the localized form delivered by the DMS.

           It is valid for there to be a null response even though there has
           been successful document retrieval.

           WARNING: Each time content changes are commited to the DMS,
               dmsAuthor() may change.


               Null response: null

           */

    java.lang.String dmsDocName();
        /* For a successful document access, dmsDocName() is an user-
           readable text that is the name of the document as maintained by
           the DMS.  This name is in the localized form delivered by the DMS
           system.

           It is valid for there to be a null response even though there has
           been successful document retrieval.

           When available, the dmsDocName() result is preferable over the
           ODMA Document ID for identification of the document to the user.

           WARNING: Each time content changes are commited to the DMS,
               dmsDocName() may change.


               Null response: null

           */


    java.lang.String dmsDocType();
        /* For a successful document access, dmsDocType() is a descriptive
           text that identifies the type of document from the perspective
           of the DMS system.  The document type is not related to the
           format of the document but to its application or use (invoice,
           pleading, memorandum, report, etc.)  This text is in the
           localized form delivered by the DMS system.

           It is valid for there to be a null response even though there has
           been successful document retrieval.

           WARNING: Each time content changes are commited to the DMS,
               dmsDocType() may change.


               Null response: null

           */


    java.lang.String dmsFormatName();
        /* For a successful document access, dmsFormatName() is the text
           that the dms employs as the Document Format Name.  This text is
           in the localized form delivered by the DMS system.

           The dmsFormatName() supplied by a DMS is not necessarily in the
           Document Format Name form that ODMJNI will accept from the
           application (e.g., as the parameter of an acceptAsNewDocument
           operation, below).

           It is valid for there to be a null response even though there has
           been successful document retrieval.

           WARNING: Although it would be unusual, it is possible that
               dmsFormatName() might change upon commiting content changes
               to the DMS.


               Null response: null

           */


    OdmPendingDocument transferToNewDocument
                            (java.lang.String docFormatName)
                       throws OdmError;

        /* For a successful document access, the transferToNewDocument
           operation invites the DMS which supplied the current document
           to create a new document using information known about the
           current document plus anything provided by interaction with the
           user.  This derivative document will be represented by a new
           OdmPendingDocument to be used in completion of content delivery
           for it.

           If the transfer request is accepted, the application must provide
           the desired content file using the returned OdmPendingDocument.

           Ordinarily, the new content will be that obtained from the
           retrieved document file, with or without changes, with or without
           alteration of the Document Format.

           The docFormatName parameter must be expressed in the same format
           accepted by OdmConnection.acceptNewDocument operations.  Don't
           use the dmsFormatName returned for the current document unless it
           has been verified as acceptable and intended.

           If the docFormatName is not a well-formed Document Format Name,
           an unchecked OdmError exception will be thrown.

           The OdmPendingDocument that is returned will have the same
           characteristics as the OdmPendingDocument returned from an
           OdmConnection.acceptNewDocument(docFormatName) operation.

           IMPORTANT: This operation does not change the status of the
               current document in any way.  Release has not occured and
               if the file at docLocation() is open it must still be
               closed before any release is performed on the current
               interface.  It is permissible to have several new documents
               created by transfer a single OdmViewingDocument.

               Null behavior: An unchecked OdmError exception is thrown
               if OdmViewingDocument.operationSucceeded() is false.

       */

    } /* OdmViewingDocument */


/* 0.08 2006-12-17-14:43 Adjust for the 0.30beta approach to failure modes,
        document release, and null behaviors.
   0.07 2006-12-14-14:27 Change "acceptAsNewDocument" to "transferToNew-
        Document," making the impact a little more clear.
   0.06 2006-12-13-20:51 Customize throughout as OdmViewingDocument and
        expand with the 0.30beta added methods.
   0.05 2006-12-12-18:57 Branch to a new file to be customized from
        OdmWorkingDocument to OdmViewingDocument.
   0.04 2006-10-22-20:39 Make the interface public.
   0.03 2006-10-22-16:53 Clean up comments for better explanation of how
        OdmWorkingDocument is created and what data is stable when.
   0.02 2006-10-22-16:27 provide clean compile sufficient for 0.05alpha.
   0.01 2006-10-22-15:59 rename as OdmWorkingDocument and extend the
        new OdmDocument intermediate interface.  Treat as separate from
        the OdmPendingDocument interface which is now being added
   0.00 2006-10-18-22:38 alpha-level version for the first evolutionary
        prototype of ODMJNI components.  This interface is intended to
        become stable very quickly during early testing and application
        integration.

   $Header: /ODMdev/info/odma/practical100/OdmViewingDocument.java 5     06-12-17 15:13 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmViewingDocument.java ***    */