/* OdmNative100i.hpp 0.21            UTF-8                   dh:2006-12-30
 *
 *           OdmNative100 EXTENDED ENTRY AND INTERFACE DEFINITIONS
 *           *****************************************************
 *
 * This header file defines additional OdmNative100 classes and interfaces
 * that are only used internal to the OdmNative100 libraries for private use
 * in the implementation.
 *
 * This header file is not part of the published headers used for access to
 * OdmNative100 classes, interfaces, and functions.  There are complex pre-
 * conditions and application dependencies involved in the use of the
 * additional methods of this interface.
 *
 *
 *
 *                         Copyright © 2006 NuovoDoc
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source code that includes this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 */

#ifndef ODMNATIVE100i_H
#define ODMNATIVE100i_H

#define OdmNative100i_H_Version_ "0.21 OdmNative100i.hpp " \
                                 "2006-12-30T23:41Z"

    /* This is a preprocessor text about this header file.  It is a
       string value that can be incorporated into other text.
       */


#ifndef __cplusplus
#error  IodmNative100i INTERFACE DEFINITIONS REQUIRE C++.  DON'T USE WITH C.
    /* XXX: We might fix this some day, but not now. */
#endif

#include <windows.h>

#include "Odma32types100.h"

#include "OdmNative100.hpp"
    /* This header extends the public OdmNative100.hpp header. */


/*                      Define IodmNative100i IID Values
                        ********************************* */

#define IID_IodmApplication100i_ { 0x2bbc8baa, 0x2e0c, 0x4951, \
                { 0xbf, 0x25, 0x20, 0xe2, 0x33, 0x2, 0x23, 0xa0 } };



        /* This IID represents both the signature and the contract for
           the private extension to IodmApplication100.  This IID is
           maintained in the same way as those in IodmNative100.hpp.

           The current IID was established with version 0.21 of this
           Interface header.
           */


/*                      Extend IodmNative Interfaces
                        **************************** */


interface IodmApplication100i : IodmApplication100
{   /* Inherit straight down from IodmApplication100 */

    virtual HINSTANCE WINAPI hConManLib(void) PURE;
        /* Returns the handle of the Connection Manager library for use in
           performing GetProcAddress operations.  NULL is returned when
           hasConMan is FALSE.

           This value will not change.  There is no action that will
           change the result for a given IodmApplication100i interface
           reference.

           This value must not be preserved beyond the lifetime of the
           holding of the IodmApplication100i interface reference.  The
           handle must not be freed by the caller.  It is owned and
           managed as part of the IodmApplication100i implementation.
           */

    virtual ODMHANDLE WINAPI hWorkingDMS(void) PURE;
        /* Returns the handle of the Working DMS instance that is held
           by the IodmApplication100i implementation.

           If there is a Default DMS, it is also the Working DMS.

           If needed when there is no Default DMS, an openDoc operation
           can establish a Working DMS in order to complete its operations.

           NULL is returned when no Working DMS has been established.

           When a non-NULL Working DMS handle has been created, it will
           not change in value.

           A non-NULL value must not be preserved beyond the lifetime of
           the IodmApplication100i interface reference through which the
           value is obtained.
           */

    };  /* IodmApplication100i */



/*                  DEFINE OTHER CLASSES AND FUNCTIONS HERE
                    *************************************** */


/* 0.21 2006-12-30-15:36 Revise for 0.30alpha functionality and beyond.

   0.20 2006-11-25-21:08 Incorporate in the 0.20alpha OdmApplication100
        release.

   0.00 2006-11-23-17:30 Obtain the information that I need for the initial
        version.  Simply extend IodmApplication100 to add functions of
        OdmApplication100i that are needed for other other components to
        coordinate with the OdmApplication100 implementation and its
        lifecycle.
        */

#endif ODMNATIVE100i_H
/* $Header: /ODMdev/info/odma/OdmNative100/OdmNative100i.hpp 3     06-12-30 16:06 Orcmid $
   */
/*                     *** end of OdmNative100i.hpp ***                  */
