/* CheckUtils.hpp 0.02               UTF-8                    dh:2007-01-17
 *
 * Utility Library of reusable functions used for the OdmNative100
 * Check programs.
 *
 */

#ifndef CHECKUTILS_H
#define CHECKUTILS_H

#ifndef __cplusplus
#error  CheckUtils REQUIRE C++.  DON'T USE WITH C.
#endif

#include <stdio.h>
    /* For FILE, fputs, stdout, ... */

#include <windows.h>

#include "Odma32types100.h"

#include "OdmWorking100.hpp"

#include "OdmPending100.hpp"


const char* hResultName(HRESULT rc);
    /* Provide string text for names of HRESULTs used by OdmNative100.
       */


const char* odmStatusName(ODMSTATUS rc);
    /* Provide string test for names of the ODMSTATUS results defined
       for ODMA 1.0 with special indication of values introduced in
       later versions of ODMA.
       */


void reportIface(        FILE *out,
                   const char indent[],
                   const char ifaceName[],
                      HRESULT rc,
                         void *pIface
                   );
    /* Present the name, result, and interface pointer obtained as the
       result of a QueryInterface or similar operation.
       */


void reportIfaceVersion(     FILE  *out,
                           LPCSTR  indent,
                           LPCSTR  pszText
                           );
    /* Report the interfaceVersion string for an interface that provides
       one.  The pszText will have '\n' codes and there needs to be
       indentation after each of them.
       */


void reportDocProp(          FILE  *out,
                           LPCSTR  indent,
                   IodmWorking100  *pIodmWrk,
                           LPCSTR  propName,
                             WORD  propNum
                   );
    /* Report the document property of a working document, using one or
       two lines depending on the nature of the value.
       */

void workWork(FILE *out, LPCSTR indent,
              LPSTR theDocId, LPSTR theDocLoc,
              IodmWorking100 *pIodmWrk);

    /* Procedure for iterating through a Working Document and reporting
       on its properties and the effect of commitChanges until no more
       changes are requested. */

BOOL workPending(FILE *out, LPCSTR indent,
                 LPSTR theDocLoc,
                 IodmPending100 *pIodmPend);

    /* Procedure to report the pending document interface, describe the
       state of the pending document, and for an operating interface,
       launch a content editor if possible, find out if the user wants
       to commit content, returning TRUE in that case, FALSE for
       everything else.
       */



/* 0.02 2007-01-18-13:42 Add workPending for reporting on a Pending
        Document and deciding whether or not to
   0.01 2007-01-17-21:53 Add workWork for cycling through Working Document
        properties and the impact of changes.

   0.00 2007-01-17-17:50 Initial skeleton for the file, with the first
        utilities being hResultName, odmStatusName, reportIface,
        reportIfaceVersion, and reportDocProp.
   */

#endif // !CHECKUTILS_H
/* $Header: /ODMdev/info/odma/OdmNative100/test/Check06/CheckUtils.hpp 3     07-01-18 16:04 Orcmid $
   */

/*                       *** end of CheckUtils.hpp ***                  */
