@echo off
rem RunCheckChoice.bat 0.01          UTF-8                    dh:2007-01-24
echo **   RunCheckChoice.bat 0.01 PERFORMING odmjni100 CONFIRMATION CHECK

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Run
ECHO:
ECHO **   RunCheckChoice.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Run
IF NOT EXIST CheckChoice.class GOTO :FAIL1
SET ERRORLEVEL=
rem         This version sets the library path on the command line.
rem         We need a better way to do this in the future.
rem         FIXME: We might want to check for the odmjni100.dll too.
ECHO:
java -cp ".;%OdmClasses%" -Djava.library.path=.;..\..\ CheckChoice
IF ERRORLEVEL 1 GOTO :FAIL2
EXIT /B 0

:FAIL0
ECHO:
ECHO **   EXECUTE RunCheckChoice.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding RunCheckChoice.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE CheckChoice.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       Use BuildCheckChoice.bat to compile the class.
ECHO:
EXIT /B 2


:FAIL2
ECHO:
ECHO **   ERRORS IN EXECUTION, ERRORLEVEL = %ERRORLEVEL%
ECHO **       Remedy depends on the available error messages from Java.
ECHO:
EXIT /B %ERRORLEVEL%

rem -----1---------2---------3---------4---------5---------6---------7----*

rem RUNNING odmjni100 INTEGRATION CONFIRMATION PROGRAM CheckChoice.

rem 0.01 2007-01-24-15:02 Expand java.library.path to find CheckUtil.dll
rem 0.00 2007-01-23-18:22 Customize from RunCheck03.bat 0.00

rem $Header: /ODMdev/info/odma/odmjni100/test/Check04/RunCheckChoice.bat 7     07-01-24 15:03 Orcmid $

rem                    *** end of RunCheckChoice.bat ***