/* OdmNullBind.java 0.01             UTF-8                   dh:2006-12-17
 *
 * The OdmNullBind class has a single, static method that is used to mirror
 * the odmjni100 OdmJniBind class.
 *
 * This class provides an application() operation that instantiates a null
 * implementation in place of the active implementation of OdmJniBind.
 *
 * Typical start-up is via a statement such as
 *
 *      odmConnection myConnection = OdmNullBind.application("MyAppId");
 *
 * Any other methods of this class are reserved for private coordination
 * among the practical100 null-implementation classes.
 */

package info.odma.practical100;

public class OdmNullBind
{
    /* This is a class of exclusively-static methods used to coordinate
     * the instantiation of other odmjni100 package classes and to
     * implement access to the OdmNative100 apparatus via static native
     * methods.
     *
     * All odmjni100 native methods are implemented on this class.  That
     * way the odmjni100.dll is tied to this single class and is fully-
     * loaded with the loading of this class (or close enough to that).
     */


    public static
        OdmConnection
            application(java.lang.String appId)
                throws OdmError

    {   /* Associate the specified Application ID with the application
           and deliver an interface appropriate to the achievement of
           a binding or not. */

        /* FIXME: We are relying on the OdmNullConnection constructor
               to check the Application ID.  That's fine once we have
               done that.
               */

        return new OdmNullConnection(appId);

        } /* application */


    } /* OdmNullBind */



/* 0.01 2006-12-17-20:05 corrections for clean compile.
   0.00 2006-12-17-19:35 Derive as an extremely-simplified version of
        odmjni100 OdmJniBind.

   $Header: /ODMdev/info/odma/practical100/OdmNullBind.java 2     06-12-17 20:07 Orcmid $
   */

/*        *** end of info.odma.practical100.OdmNullBind.java ***         */