/* OdmNullPendingDocument.java 0.07  UTF-8                   dh:2007-01-20
 *
 * The OdmNullPendingDocument class implements the default null behaviors
 * for OdmPendingDocument interfaces.  This class extends OdmNullDocument
 * to provide the standard default null behavior for pending documents.
 *
 * Note that these are always for null-document implementations and can
 * be delivered from non-null operations but do not ever deliver null
 * documents themselves.  The idea is that attempting an operation that
 * depends on existence of a document will provoke an unchecked OdmError
 * exception because this must be an unrecoverable error on the part of
 * the application.
 */

package info.odma.practical100;

public class OdmNullPendingDocument
          extends OdmNullDocument
          implements OdmPendingDocument

{   /* Instance Variables and Constructor
     * ----------------------------------
       */

    protected OdmNullPendingDocument(int myFlavor)
    {   /* We simply expand the OdmNullDocument operation. */

        super(myFlavor);

        } /* OdmNullPendingDocument */



    /* OdmInterface Interface Method Implementations
     * ---------------------------------------------
     */

    public java.lang.String interfaceImplementation()
    {   /* Return a text string describing this implementation */

        return "ODMJNI 1.0 OdmNullPendingDocument 0.07";
            /* Over-ride with our identification. */

            /* FIXME: We could show our flavor too. */
        }


    /* OdmDocument Interface Method Implementations
     * --------------------------------------------
     *
     * The implementations of OdmNullDocument are all applicable here.
     */


    /* OdmPendingDocument Interface Method Implementations
     * ---------------------------------------------------
     */


    public java.lang.String docSubmissionLocation()
    {   /* There is no location available with this null document. */

        return null;
        }


    public OdmWorkingDocument commitContent()
                throws OdmError
    {   /* There is no document and an application should never reach
           this point in a returned null-document implementation.
           */

        throw new OdmError("Invalid commitContent: "
                            + interfaceImplementation());

        } /* commitContent */


    } /* OdmNullPendingDocument */


/* 0.07 2007-01-20-17:56 Make OdmNullPendingDocument a public class so it
        can be used to build OdmJniPend.
   0.06 2006-12-17-20:29 Corrections to get clean compile in BuildClasses
   0.05 2006-12-17-18:09 Change to implement null-on-null, exceptions,
        and the revised state-transition model.
   0.04 2006-12-16-23:10 Change to not hold onto the null connection
        beyond the duration of the constructor.
   0.03 2006-12-16-15:55 Expand to handle the 0.30alpha cases.
   0.02 2006-10-23-15:17 Eliminate linking to the connection instance from
        the null document.  The cyclic dependency is unnecessary.
   0.01 2006-10-22-23:51 Correct access privileges to support interfaces.
   0.00 2006-10-22-22:53 alpha-level version for the first evolutionary
        prototype of the OdmNullPendingDocument implementation.  This class
        will be maintained consistent with the OdmPendingDocument interface
        and its null behaviors as the prototype package is evolved.

   $Header: /ODMdev/info/odma/practical100/OdmNullPendingDocument.java 9     07-01-20 18:03 Orcmid $
   */

/*   *** end of info.odma.practical100.OdmNullPendingDocument.java ***   */