/*  ConIO: 0.04 Console Input-Output Classes (ALPHA)
    0.04 2003-07-11-16:59 correct the installation instructions to reflect the
         correct interfaces associated with the different reference classes.
    0.03 2003-07-09-14:05 correct the installation instructions with regard to the name of
         ConOutStream and what it implements.
    $Header: /Java2/com/orcmid/io/alpha/ConIO.java 4     03-07-11 17:08 Orcmid $ */

            /* This material is valid for all java APIs since JDK 1.1.
               It is designed to be executed as a console application.
               
               This file defines classes that provide reference implementations
               for Console Input-Output framework classes.  The classes will be
               evolved to demonstrate how tightly we can support and enforce
               design-by-contract operation.
               
               WARNING: THIS IS ALPHA-LEVEL MATERIAL.  THE CLASSES AND
               INTERFACES ARE NOT VERSIONED.  THE MATERIAL IS SUBJECT
               TO CHANGE WITHOUT NOTICE.  THERE IS NO COMMITMENT TO 
               ADVANCE ALPHA MATERIALS TO PRODUCTION QUALITY OR TO A
               RELEASE VERSION.
               */

/*  INSTALLATION INSTRUCTIONS
    *************************
    
    1.  For alpha-test usage of these classes, place this file in a directory
        where alpha-level interface classes have already been compiled.  
        
    2.  Compile this file.  Five class files will be produced:
            ConOutStream.class      implementing IConOut
            ConWriter.class         implementing IConOut 
            ConReader.class         implementing IConIn
            ConLineIO.class         implementing IConLineIO
            ConIO.class             implementing IConLineIO, IConIn
            
    3.  The files are used, in conjunction with the interface classes, in
        demonstration, confirmation, and testing applications.
        
    4.  NOTE: These classes are defined for use within a default package only.
        They cannot be imported, only used from applications that name the
        classes directly.  The application must be compiled into the same
        directory and executed from that directory.  
    */
    
    

/*  THE INTERFACE-IMPLEMENTING CLASSES
    **********************************
    */
    
class ConOutStream extends java.io.PrintStream implements IConOut
{/* 0.01 2003-06-19-14:41 Initial version of an IConOut-implementing
         class for confirmation, testing and experimental operation.
         See the warnings and notes in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/ConIO.java 4     03-07-11 17:08 Orcmid $
    */
    
    /* A class that operates exactly the same as a PrintStream and
       also implements the IConOut interface.*/
       
    /* WARNING: PROVISIONAL CLASS.  THIS CLASS IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       CHARACTER SET WARNING: THIS IMPLEMENTATION IS NOT ASSURED TO
       IMPLEMENT UNICODE SUPPORT PROPERLY, WHICH IS PART OF THE CONTRACT
       FOR IConOut.  The definition of IConOut is Unicode specific.  This
       situation will be corrected following additional confirmation and
       testing operations.
       
       This class depends on IConOut methods being identical to those
       of the PrintStream class that we want to expose via the interface.
       No method overloadings are assumed to be required.  
       
       The only provision of this class is introduction of a constructor
       just like that of PrintStream for making an autoflushed PrintStream.
       
       IConOut is defined as an autoflush stream with buffering, so auto-
       flush operation is defined.  PrintStream does more autoflush than
       the interface contracts, but that is acceptable.
       
       What may not be acceptable is the fact of PrintStream being a byte
       interface.  This may not be acceptable and we may need to use class 
       ConWriter only.
       
       Also, it might be worthwhile to block the methods from the superclass
       that we don't want to allow.  Meanwhile, let's see what we have.  We
       need to see if we can actually make that happen.  We have not resolved
       all of the cast operations that are possible and how much control we
       might have over them.
       */
       
    ConOutStream(java.io.OutputStream stream)
    {  /* Simply construct the PrintStream and let inheritance do 
          all of the rest of the work for supporting the interface.
          */
       super(stream, true);
        }
    
    } // class ConOutStream
    
    
class ConWriter extends java.io.PrintWriter implements IConOut
{/* 0.01 2003-06-19-15:36 Another IConOut-implementing class for
         confirmation, testing and experimental operation.
         See the warnings and notes in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/ConIO.java 4     03-07-11 17:08 Orcmid $
    */
    
    /* A class that operates exactly the same as a PrintWriter and
       also implements the IConOut interface.*/
       
    /* WARNING: PROVISIONAL CLASS.  THIS CLASS IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       This class assumes that IConOut methods are identical to those
       of the PrintWriter class and that there are no method overloadings
       required.  
       
       The only provision of this class is introduction of constructors
       just like those of PrintWriter for making an autoflushed ConWriter.
       
       Also, it might be worthwhile to block the methods from the superclass
       that we don't want to allow.  See the discussion for ConOutStream.
       */
       
    ConWriter(java.io.OutputStream stream)
    {  /* Simply construct the PrintWriter and let inheritance do 
          all of the rest of the work for supporting the interface.
          */
       super(stream, true);
        }
        
    ConWriter(java.io.Writer writer)
    {  /* Alternatively, simply construct the PrintWriter from a
          supplied Writer.
          */
       super(writer, true);
       }
    
    } // class ConWriter
    

class ConReader extends java.io.BufferedReader implements IConLineIn, IConIn
{/* 0.01 2003-06-19-17:02 Provide a direct console input implementation
         class for confirmation, testing and experimental operation.
         See the warnings and notes in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/ConIO.java 4     03-07-11 17:08 Orcmid $
    */
    
    /* A class that operates exactly the same as a BufferedReader and
       also implements the IConIn interfaces.
       */
       
    /* WARNING: PROVISIONAL CLASS.  THIS CLASS IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       This class assumes that IConIn methods are identical to those
       of the BufferReader class and that there are no method overloadings
       required.  
       
       The only provision of this class is introduction of a constructor
       just like for BufferedReader for making an autosized buffered case.
       
       I have not resolved whether buffer sizing should be allowed also.
       I have been avoiding that just so I don't have to deal with the
       additional exception for that argument.  I am inclined to believe
       that default case works just fine for a console style of operation.
       
       Also, it might be worthwhile to block the methods from the superclass
       that we don't want to allow.  Meanwhile, let's see what we have.
       
       Also, I am supporting IConLineIn and IConIn, and that provides a
       loophole for getting to read() and ready() secretly.   If I block
       methods, I should also make another Line-only version of this.
       Because IConIn extends IConLineIn, I can't hide it when IConIn
       is implemented.  I guess the thing to do is make read and ready work
       properly.
       */
  
       ConReader(java.io.Reader stream)
       {/*  Simply initialize the super class and let everything else be
            handled by inheritance.
            */
            
            super(stream);
            }
            
       ConReader(java.io.InputStream stream)
       {/*  Make a friendly constructor that is more convenient for
            working with System.in and other given InputStream objects.
            */
            
            super(new java.io.InputStreamReader(stream));
            }
            
    } // class ConReader
    
    
class ConLineIO extends ConWriter implements IConLineIO
{/* 0.03 2003-07-11-17:03 Correct comment at the end-bracket for this class.
    0.02 2003-06-20-12:42 Add default constructor a la ConIO implementation.
    0.01 2003-06-19-16:52 Provide a direct console line input-output
         class for confirmation, testing and experimental operation.
         See the warnings and notes in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/ConIO.java 4     03-07-11 17:08 Orcmid $
    */
    
    /* A class that operates exactly the same as a ConWriter with
       the additional input operations added.  Because there is no
       multiple inheritance, I can't just blend in a ConLineReader
       class.  So I will introduce the reader by containment.  This
       puts some delay into the readLine call.
       
       The appeal of this class and the corresponding interfaces is 
       that it allows a single bundle to be passed around that 
       supplies the separate interfaces and all of the operations 
       in one nice package.
       
       The confinement of the ConLineIn operations is an added bonus.
       */
       
    /* WARNING: PROVISIONAL CLASS.  THIS CLASS IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       Notice that all of the interfaces implemented by ConWriter are
       automatically implemented by ConLineReaderWriter.  
       
       Because I have used containment, there is no sneak path to the
       use of read, ready, and other methods of the Buffered Reader.
       This provides a solution to the ConLineReader case, mentioned
       in the ConReader notes.  There is a way out!
       
       If superclass restrictions need to be added, they can be done
       up there.
       
       I am allowing the full variation of constructors, so there is no
       loss of convenience in using this case.  Notice that a buffered
       reader will not be constructed again if an interface is available.
       That is, I don't care how the reader is built and will use one that
       someone can provide me.  It is an interesting braintwister to 
       be reconciled with that not working for an instance of our superclass
       or an existing interface.  But a function that delivers an object
       with all of these interfaces works just fine!  More to think about.
       */
       
       
    private IConLineIn conIn;
        /* The internally-contained input-method implementation.
           There may be a lot of mileage to obtain from this scheme.
           */
       
    ConLineIO(java.io.OutputStream out, java.io.InputStream in)
    {   /* Build ourselves and contain the reader we build.
           This implementation is chosen because there is no advantage
           to using a ConLineReader that filters the methods that
           we want to use.
           */
        super(out);
        conIn = new ConReader(in);
        }   
        
    ConLineIO(java.io.OutputStream out, IConLineIn inLine)
    {   /* If an interface is provided, use it */
        super(out);
        conIn = inLine;
        }
        
    ConLineIO(java.io.OutputStream out, java.io.Reader in)
    {   /* The remaining case. */
        super(out);
        conIn = new ConReader(in);
        }
        
    ConLineIO(java.io.Writer out, java.io.InputStream in)
    {   /* Now do the same thing using the alternative Writer source
           */
        super(out);
        conIn = new ConReader(in);
        }   
        
    ConLineIO(java.io.Writer out, IConLineIn inLine)
    {   /* If an interface is provided, use it */
        super(out);
        conIn = inLine;
        }
        
    ConLineIO(java.io.Writer out, java.io.Reader in)
    {   /* The remaining case. */
        super(out);
        conIn = new ConReader(in);
        }
        
    ConLineIO()
    {   /* Provide default construction using java.lang.System. */
        super(java.lang.System.out);
        conIn = new ConReader(java.lang.System.in);
        } // 0.02
    
    public String readLine() throws java.io.IOException
    {   /* Our one relay operation.  This is all we need for adding
           in the only input method our interface supports.
           */
        return conIn.readLine();
        }
        
    } // class ConLineIO
    
    
class ConIO extends ConWriter implements IConIO
{/* 0.01 2003-06-19-21:25 Provide a direct full console input-output
         class for confirmation, testing and experimental operation.
         See the warnings and notes in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/ConIO.java 4     03-07-11 17:08 Orcmid $
    */
    
    /* A class that operates exactly the same as a ConWriter with
       the additional input operations added.  Because there is no
       multiple inheritance, I can't just blend in a ConReader
       class.  So I will introduce the reader by containment.
       
       The appeal of this class and the corresponding interfaces is 
       that it allows a single bundle to be passed around that 
       supplies the separate interfaces and all of the operations 
       in one nice package.
       */
       
    /* WARNING: PROVISIONAL CLASS.  THIS CLASS IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       Notice that all of the interfaces implemented by ConWriter are
       automatically implemented by ConIO.  
       
       If superclass restrictions need to be added, they can be done
       up there.  
       
       Note that if I don't want it to be possible to cast from an
       IConLineIn to an IConIn, I need to change the inheritance structure
       so that can't happen.  That looks like a good idea.  I'll evaluate
       the possibility of that in the next version.
       */
       
       
    private IConIn conIn;
        /* The internally-contained input-method implementation.
           There may be a lot of mileage to obtain from this scheme.
           */
       
    ConIO(java.io.OutputStream out, java.io.InputStream in)
    {   /* Build ourselves and contain the reader we build.
           This implementation is chosen because there is no advantage
           to using a ConLineReader that filters the methods that
           we want to use.
           */
        super(out);
        conIn = new ConReader(in);
        }   
        
    ConIO(java.io.OutputStream out, IConIn inLine)
    {   /* If an interface is provided, use it */
        super(out);
        conIn = inLine;
        }
        
    ConIO(java.io.OutputStream out, java.io.Reader in)
    {   /* The remaining case. */
        super(out);
        conIn = new ConReader(in);
        }
        
    ConIO(java.io.Writer out, java.io.InputStream in)
    {   /* Now do the same thing using the alternative Writer source
           */
        super(out);
        conIn = new ConReader(in);
        }   
        
    ConIO(java.io.Writer out, IConIn inLine)
    {   /* If an interface is provided, use it */
        super(out);
        conIn = inLine;
        }
        
    ConIO(java.io.Writer out, java.io.Reader in)
    {   /* The remaining case. */
        super(out);
        conIn = new ConReader(in);
        }
        
    ConIO()
    {   /* Provide default construction using java.lang.System. */
        super(java.lang.System.out);
        conIn = new ConReader(java.lang.System.in);
        }
    
    public String readLine() throws java.io.IOException
    {   /* The readLine() implementation from ConReader */
        return conIn.readLine();
        }
        
    public int read() throws java.io.IOException
    {   /* The read() implementation from ConReader */
        return conIn.read();
        }
        
    public boolean ready() throws java.io.IOException
    {   /* The ready() implementation from ConReader */
        return conIn.ready();
        }
        
    } // class ConIO

    
                        /* end of ConIO.java */
