/* OdmBindPending100.hpp 0.00        UTF-8                   dh:2007-01-15
 *
 *                       OdmPending100 FACTORY FUNCTION
 *                       ******************************
 *
 * This header file defines the entry to the OdmBindPending100 factory
 * function for implementation of the IodmPending100 interface.  This is
 * used privately among the OdmNative object implementations and is not
 * needed to use the public OdmNative interfaces.
 *
 *                       Copyright © 2006-2007 NuovoDoc
 *                            <http://NuovoDoc.com>
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source files that include this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 */

#ifndef ODMBINDPENDING100_H
#define ODMBINDPENDING100_H


#ifndef __cplusplus
#error  OdmBindPending100 ENTRY REQUIRES C++.  DON'T USE WITH C.
    /* XXX: We might fix this some day, but not now. */
#endif

#include <windows.h>


/*                       Define OdmBindPending100 Entry
                         ****************************** */


HRESULT WINAPI
    OdmBindPending100(   void *pIodmApp, /* Reference to an IodmApplication
                                            interface
                                            */
                       LPCSTR pszDocId,  /* ODMA Document ID of the new DMS
                                            document for which content is
                                            to be provided.
                                            */
                       LPCSTR pszDocLoc, /* ODMA Document Location to use
                                            in submitting content for the
                                            document.
                                            */
                       REFIID rIID,      /* The requested interface
                                            */
                         void **ppIface  /* The location to receive the
                                            Interface pointer or NULL
                                            */
                       );

        /* OdmBindPending100 constructs an OdmPending object that
           is tied to the given IodmApplication interface (which it uses
           for infrastructure functions) and the specific Document ID and
           Document Location.

           The created object supports at least IUnknown and IodmPending100.
           */


/* 0.00 2007-01-15-18:04 Craft from OdmBindWorking100.hpp 0.02.
        This is only used internally to OdmNative and is not needed to make
        use of OdmNative interfaces and the public factory.
        */

#endif ODMBINDPENDING100_H
/* $Header: /ODMdev/info/odma/OdmNative100/OdmBindPending100.hpp 2     07-01-15 18:11 Orcmid $
   */

/*                   *** end of OdmBindPending100.hpp ***                */
