/* OdmPending100.hpp 0.01            UTF-8                   dh:2007-01-19
 *
 *                    OdmPending100 INTERFACE DEFINITIONS
 *                    ***********************************
 *
 * This header file defines the OdmPending100 interface.  The OdmPending100
 * is used to delier all of the OdmNative support required to implement
 * an OdmPendingDocument interface Only the public IodmPending100 interface
 * is defined here.  The factory function is private to the OdmNative class
 * implementations and is never used external to the OdmNative100 library.
 *
 * There may be other uses for OdmNative interfaces and classes in the
 * future, but for now the purposes and use cases for the interfaces
 * are stated in terms of ODMJNI feature behavior.
 *
 *                       Copyright © 2006-2007 NuovoDoc
 *                           <http://NuovoDoc.com>
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source files that include this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 *
 * FIXME: There will be a major refactoring to raise the level of abstrac-
 *        tion and encapsulation in the delivery of practical functions
 *        that return HRESULTs and express the still-needed ODMSTATUS
 *        values in HRESULTS for compact delivery of completed operations.
 *
 *        The preamble to OdmNative100.hpp has more about the motivation
 *        and approach.
 *
 *        These changes will not occur until after the 0.50beta ODMJNI 1.0
 *        release.
 *
 *        There will be minor impact here.  It will change how commitContent
 *        works.
 */


#ifndef ODMPENDING100_H
#define ODMPENDING100_H

#define OdmPending100_H_Version_ "0.01 OdmPending.hpp " \
                                 "2007-01-20T07:09Z"

    /* This is a preprocessor text about this header file.  It is a
       string value that can be incorporated into other text.
       */

#ifndef __cplusplus
#error  IodmWorking100 INTERFACE DEFINITION REQUIRES C++.  DON'T USE WITH C.
    /* XXX: We might fix this some day, but not now. */
#endif

#include <windows.h>

#include "Odma32types100.h"
    /* Stick with the ODMA 1.0 Types and Values definitions */

/*                        Define IodmPending IID Values
                          ***************************** */

    /*  Each interface has a globally-unique Interface ID (IID).  The
        IIDs are specified by Microsoft for the standard COM interfaces
        such as IUnknown.  For the IodmNative-unique interfaces, the IIDs
        have been generated using the GuidGen.exe tool provided with
        the Microsoft Platform SDK.
        */


#define IID_IodmPending100_ { 0xad93d138, 0xb297, 0x40be, \
                    { 0x80, 0x16, 0xea, 0x1e, 0x34, 0x1e, 0xd6, 0x0 } }


        /* This IID represents both the signature and the contract for
           the 0.50beta version of IodmPending100.  Every time the
           signature and contract change for a version released to the
           wild, there will be a new IID.  This is a safeguard against
           calling for an implementation of a different interface contract
           than the one represented by this header file and definition of
           the associated behavior.

           See the explanation in OdmNative100.hpp for further details of
           this approach.
           */


/*                     Define IodmPending Interface
                       **************************** */


interface IodmPending100 : IUnknown
{   /* Inherit from IUnknown as required for all COM interfaces

       This interface is only available for a successfully-created,
       fully usable pending-document object.  The ODMA Document ID is known
       and the docLocation that the DMS has defined for delivery of content
       to it has been defined.

       More assumptions about the conditions under which this interface
       should ever be delivered are provided in the comments on the
       individual  methods.
       */

    /* ODMJNI OdmInterface Counterparts in IodmPending
     * -----------------------------------------------
     *
     * For this interface to have been produced, it must have been the
     * case that IodmApplication100.hasConMan() is true and remains true
     * so long as there is any implementation of the IodmWorking100
     * interface that has not been released.
     *
     * The counterpart of ODMJNI OdmInterface.release() is the
     * IUnknown::release() method.  There is no separate release and
     * there is no interface available after release, so there is no
     * need for null behaviors on the methods.  This must be handled in
     * the wrapper, whether ODMJNI or some other wrapper.
     */

    virtual LPCSTR WINAPI interfaceImplementation(void) PURE;
        /* A constant '\0'-terminated char string of '\n'-separated lines
           that identify the version of I0dmPending100 implementation.
           This constant is available only so long as the interface is
           held.  A copy must be made for use beyond that duration.

           FIXME: We need a defined convention for this format and how
           to use it in reporting, as in an eventlog or test report.  That
           applies for all of the OdmNative cases of this interface.
           */


    /* ODMJNI OdmDocument Counterparts in IodmPending100
     * -------------------------------------------------
     *
     * For an IodmPending100 interface to have been delivered, it must
     * be the case that, for a wrapper like ODMJNI,
     *
     *         OdmDocument.dmsAvailable() is true.
     *
     *         OdmDocument.operationSucceeded() is true.
     *                    .operationCancelled() is false.
     *                    .localOperationRequested() is false.
     *
     * There is no need for IodmPending100 to provide counterparts
     * of any of those functions.
     *
     * In terms of OdmNative and ODMA operations, it must be the case that
     *
     *         IodmApplication100i.hConManLib() is non-NULL
     *         IodmApplication100i.hWorkingDMS() is a non-NULL ODMHANDLE
     *
     * and the ODMA Document Id and ODMA Document Location parameters used
     * in the implementation of the interface are valid and accessible to
     * the application of OdmPending100.
     */


    /* ODMJNI OdmPendingDocument Counterparts in IodmPending100
     * --------------------------------------------------------
     *
     * The OdmPendingDocument functions are supported by the following
     * IodmPendiing100 methods.
     */


    virtual LPCSTR WINAPI docLocation(void) PURE;
        /* The ODMA DMS representation of the common file location is
           carried in this string.  There must always be an ODMA docLocation
           reflected in this string.

           This string is available only until the IodmPending100 interface
           is released.  Any reference to the string will be invalid after
           release.

           This string does not change for the lifetime of the interface
           reference.

           If commitContent fails, the last value will be retained.  It is
           not necessarily meaningful for use, however.
           */


    virtual HRESULT WINAPI
        commitContent(   IUnknown **pIUnk /* The location to receive the
                                             IUnknown interface for the
                                             new Working Document */
                         ) PURE;

        /* Before using this method, first save all content for the file
           to docLocation() and close the file.

           If commitContent succeeds() the returned interface is for an
           OdmWorking object that implements the initial saved-form of the
           document as a modifiable working document.  All further
           operations are performed with that object and interface.

           If the commitContent does not succeed in submitting the content
           to the DMS, E_FAIL is returned.  Other HRESULT error codes can
           also be produced.

           All entries to commitContent after the first will always return
           E_FAIL.

           On return of S_OK, the (*pIUnk) -> QueryInterface function can
           be used to obtain the desired interface for further operation.
           An IUnknown is always returned so that there is opportunity to
           negotiate a correct interface without losing the object that
           implements the delivered IUnknown pointer.
           */


    };  /* IodmPending100 */



/* 0.01 2007-01-19-23:09 Correct the self-identification line in this
        header.

   0.00 2007-01-15-18:25 Using the basic model of OdmWorking100 0.04,
        distill out the interface for OdmPending100.
   */

#endif ODMPENDING100_H
/* $Header: /ODMdev/info/odma/OdmNative100/OdmPending100.hpp 3     07-01-19 23:10 Orcmid $
   */
/*                     *** end of OdmPending100.hpp ***                  */
