/* CheckUtil.cpp 0.00                 UTF-8                   dh:2007-01-24
 *
 * This is the implementation for all all of the native-method entries
 * for CheckUtil.class in the default package at odmjni100\test\Check04\
 *
 * It is compiled into a DLL that is then used by the Java run-time to
 * deliver implementations for the named class methods.
 */

#include <stdlib.h>
    /* For system and errno */

#include <stdio.h>
    /* For _flushall */

#include <jni.h>
    /* for the JNIEnv and other declarations. */

#include "CheckUtilx.h"
    /* The header we are conforming to. */



JNIEXPORT
    jint JNICALL
        Java_CheckUtil_doCommand
            (    JNIEnv *pIenv,     /* For String conversion to ASCII */
                 jclass pThisClass, /* not used */
                jstring jCommand    /* text of the command */
                )

{   /* Just flush the buffers, convert jCommand from Java Unicode, and
       execute it.  Return a composed error code that is either the
       return code from the command or a negative of an errno that
       occured.
       */

    _flushall();

    const char *pszCommand
        = pIenv -> GetStringUTFChars(jCommand, NULL);

    int rc = system(pszCommand);

    if (rc < 0)
         rc = -errno;

    pIenv -> ReleaseStringUTFChars(jCommand, pszCommand);

    return rc;

    } /* doCommand */


/* 0.00 2007-01-24-14:21 Implement doCommand for launching programs
        in the confirmation checking of odmjni100.

   $Header: /ODMdev/info/odma/odmjni100/test/Check04/CheckUtil.cpp 1     07-01-24 15:06 Orcmid $
   */

/*                       *** end of CheckUtil.cpp ***                 */
