/* OdmDocument.java 0.06             UTF-8                  dh:2006-12-17
 *
 * The OdmDocument interface provides common features that apply to all
 * managed documents accessed via ODMA.
 *
 * There is no ODMJNI object that implements only OdmDocument.  One of the
 * extensions of OdmDocument is always used: OdmPendingDocument,
 * OdmWorkingDocument, or OdmViewingDocument.
 *
 * When an OdmDocument interface is released, only resources that are
 * associated with the single document are released.  There is no impact
 * on OdmConnection and different OdmDocument interfaces still held by the
 * application.
 */

package info.odma.practical100;

public interface OdmDocument extends OdmInterface
{
    boolean dmsAvailable();
        /* True when there is an available ODMA DMS associated with the
           document for which this interface applies.  The DMS will be
           the one responsible for the management of the document being
           created or accessed.  It need not be the defaultDMS associated
           with the application.

           If true is returned, that will continue to be the result until
           the interface is released.  dmsAvailable() is never true
           when OdmDocument.available() is false.

               Null response: false
           */


    boolean operationSucceeded();
        /* True when the operation that returned this Document interface
           succeeded.

               Null response: false
           */

    boolean operationCancelled();
        /* True when the operation that returned this Document nterface
           did not succeed because it was cancelled, usually at the request
           of the application user through interaction with the DMS.  This
           should be treated the same as if the operator had cancelled a
           local Open ... dialog, cancelling both the ODMA dialog and any
           local one (but see below).

           DEVELOPER WARNING: The standard response to operationCancelled
               is vulnerable to a stuck-cancel response from the DMS.
               (Such conditions have occured in production operation.)  This
               can leave operators with no way to save their work, since
               it appears as if nothing is happening in response to their
               Save or Save As ... requests.  The user may be left with no
               alternative to lose work in order to close the application.

                  To avoid stuck-cancel situations, it is recommended that,
               at worst, operations that are needed to preserve unsaved
               work always treat an operationCancelled response as a form of
               localOperationRequested() situation.  The operator should be
               given the opportunity to choose an alternative ODMJNI
               function and always have a local operation available as a
               last resort.

                  An application may provide more-sophisticated heuristic
               behavior in order to detect that an user-requested operation
               is receiving repetitive operationCancelled() outcomes from
               ODMJNI and that silently cancelling all interaction should be
               modified in case there is a stuck-cancel condition.

                   [It is not possible for ODMJNI to detect a stuck-cancel
                   condition automatically.  There is not enough informa-
                   tion about activity of the user and the function of the
                   application that the ODMJNI request is being used to
                   implement.]

               Null response: false

           */

    boolean localOperationRequested();
        /* True when the operation that returned this interface did not
           succeed because the application usr or ODMJNI requests that the
           application provide local operation instead of using an ODMA DMS
           operation.

               Null response: true except from an openKnownDocument request

           */

        /* At most one of the above operations will return true following
           an operation.  When none return true, the operation failed.
           There is generally no action to perform that will remove the
           failure condition.  ODMA-aware applications should be designed
           to behave defensively on behalf of their users and provide a
           simple workaround (e.g., switch to local operation with an
           appropriate notification that an ODMA operation failed).
           */

    } /* OdmDocument */


/* 0.06 2006-12-17-13:41 Adjust to reflect the hard null-failure cases
        and the way that OdmDocument release and document changes are
        handled starting with 0.30alpha.
   0.05 2006-12-13-20:26 Reflect the change from availableConnection()
        to OdmDocument.available().
   0.04 2006-12-12-21:23 Review and cleanup for consistency with the
        0.30alpha release.
   0.03 2006-10-22-23:59 Make interface public. Leaving it non-public
        prevents visibility outside of the package.
   0.02 2006-10-22-20:42 Make interface non-public to see if methods still
        work on extensions even if the interface is not separately usable.
   0.01 2006-10-22-15:54 obtain clean compilation of the interface.
   0.00 2006-10-22-14:39 refactoring of common operations used for both
        OdmPendingDocument and OdmWorkingDocument.

   $Header: /ODMdev/info/odma/practical100/OdmDocument.java 6     06-12-17 14:07 Orcmid $
   */

/*        *** end of info.odma.practical100.OdmDocument.java ***       */