@echo off
rem RunSwingApp.bat 0.00             UTF-8                    dh:2007-01-31
echo **   RunSwingApp.bat 0.00 PERFORMING %1 SWING APPLICATION
IF "%1" == "" GOTO :USAGE

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Run
ECHO:
ECHO **   RunSwingApp.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:USAGE
ECHO:
ECHO **   USAGE:
ECHO **       RunSwingApp appName
ECHO **
ECHO **   where      appName is the name of the application and
ECHO **        appName.class is the application class to execute
ECHO:
EXIT /B 1

:Run
IF NOT EXIST %1.class GOTO :FAIL1
SET ERRORLEVEL=
rem         This version sets the library path on the command line.
rem         We need a better way to do this in the future.
rem         FIXME: We might want to check for the odmjni100.dll too.
ECHO:
java -cp ".;%OdmClasses%" -Djava.library.path=.;..\..\ %1
IF ERRORLEVEL 1 GOTO :FAIL2
EXIT /B 0

:FAIL0
ECHO:
ECHO **   EXECUTE RunSwingApp.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding RunSwingApp.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE %1.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       Use BuildSwingApp.bat %1 to compile the class.
ECHO:
EXIT /B 2


:FAIL2
ECHO:
ECHO **   ERRORS IN EXECUTION, ERRORLEVEL = %ERRORLEVEL%
ECHO **       Remedy depends on the available error messages from Java.
ECHO:
EXIT /B %ERRORLEVEL%

rem -----1---------2---------3---------4---------5---------6---------7----*

rem RUNNING odmjni100 SWING GUI COORDINATION CHECK

rem 0.00 2007-01-31-17:51 Customize from RunCheckChoice.bat 0.01

rem $Header: /ODMdev/info/odma/odmjni100/test/CheckSwing/RunSwingApp.bat 1     07-01-31 19:00 Orcmid $

rem                  *** end of RunCheckSwingApp.bat ***