@echo off
rem BuildSwingApp.bat 0.00           UTF-8                   dh:2007-01-31
ECHO **   BuildSwingApp.bat 0.00 COMPILING SWING CONFIRMATION TEST
IF "%1" == "" GOTO :USAGE
ECHO:         This %1 application demonstrates Java GUI Operation as part
ECHO:         of confirming proper ODMJNI 1.0 integration into Java GUI
ECHO:         desktop applications.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 1 GOTO :Compile
ECHO **   BuildSwingApp.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:USAGE
ECHO:
ECHO **   USAGE:
ECHO **       BuildSwingApp appName
ECHO **
ECHO **   where      appName is the name of the application and
ECHO **         appName.java is the source program to compile
ECHO:
EXIT /B 1


:Compile
IF NOT EXIST %1.java GOTO :FAIL1

rem erase *.class probably not needed for our single-file apps.
SET ERRORLEVEL=
javac -cp ".;%OdmClasses%" %1.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   %1.class COMPILED
ECHO **   *****************
echo:
echo:     There are no errors or warnings.  This program can be run
echo:     via command RunSwingApp.bat %1
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildSwingApp.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding BuildSwingApp.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE %1.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       BuildSwingApp.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildSwingApp %1 into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA APPLICATION TO DEMONSTRATE GUI COORDINATION WITH ODMA
rem     Build a progression of Swing applications that demonstrate greater
rem     integration of ODMJNI so that the proper ODMA DMS dialog and
rem     ODMA Logging is confirmed.

rem 0.00 2007-01-31-17:44 Customize from BuildCheckChoice.bat 0.01.  This
rem      version erases no *.class files prior to any build.

rem $Header: /ODMdev/info/odma/odmjni100/test/CheckSwing/BuildSwingApp.bat 1     07-01-31 19:00 Orcmid $

rem                   *** end of BuildSwingApp.bat ***