@echo off
rem BuildDLL.bat 0.00                UTF-8                    dh:2007-01-24
ECHO **** BuildDLL.bat 0.00 COMPILING CheckUtil.dll

IF NOT EXIST ..\..\OdmJNI.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJNI.bat
popd
IF NOT ERRORLEVEL 1 GOTO :Compile
ECHO **** BuildDLL.bat ABORTED.  SEE THE OdmJNI.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST CheckUtil.cpp GOTO :FAIL1

SET ERRORLEVEL=
cl /WX /MT /LD CheckUtil.cpp /link /MANIFEST:NO
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **** CheckUtil.dll COMPILED
echo **** **********************
echo:
echo:     There are no errors or warnings.  This DLL is used by the
echo:     Java default package at odmjni100\test\Check04 for the native
echo:     method implementations declared in the CheckUtil.class.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **** EXECUTE BuildDLL.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO ****     The OdmJNI.bat script must be available above that location.
ECHO ****     Verify your odmjni100 configuration and ensure that the
ECHO ****     directory holding this BuildDLL.bat is the current working
ECHO ****     directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **** THE CheckUtil.cpp FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO ****     The file should be in the same directory as this BuildDLL
ECHO ****     script.  BuildDLL.bat is aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **** ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo ****     To capture a log, run with redirection to a file or pipe the
echo ****     result of BuildDLL.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD DLL FROM C++ LANGUAGE IMPLEMENTATION OF CheckUtil METHODS.
rem This script builds the DLL that carries implementations of all
rem native methods declared in the CheckUtil class.


rem 0.00 2007-01-24-14:45 customized from odmjni100 BuildDLL.bat

rem $Header: /ODMdev/info/odma/odmjni100/test/Check04/BuildDLL.bat 1     07-01-24 15:05 Orcmid $

rem                         *** end of BuildDLL.bat ***