/* CheckUtil.cpp 0.01                 UTF-8                   dh:2007-02-12
 *
 * This is the implementation for all all of the native-method entries
 * for CheckUtil.class in the default package at odmjni100\test\Check04\
 *
 * It is compiled into a DLL that is then used by the Java run-time to
 * deliver implementations for the named class methods.
 */

#include <stdlib.h>
    /* For system and errno */

#include <errno.h>
    /* For the definitions of the errno values */

#include <stdio.h>
    /* For _flushall */

#include <jni.h>
    /* for the JNIEnv and other declarations. */

#include "CheckUtilx.h"
    /* The header we are conforming to. */



JNIEXPORT
    jint JNICALL
        Java_CheckUtil_doCommand
            (    JNIEnv *pIenv,     /* For String conversion to ASCII */
                 jclass pThisClass, /* not used */
                jstring jCommand    /* text of the command */
                )

{   /* Just flush the buffers, convert jCommand to null-terminated
       Unicode, and execute it.  Return a composed error code that is
       either the return code from the command or a negative of an errno
       that occured.
       */

    _flushall();

    #define MAX_COMMAND (100)

    jsize uLength = pIenv -> GetStringLength(jCommand);

    if (uLength > MAX_COMMAND)
         {  _set_errno(E2BIG);
            return -errno;
         }

    wchar_t uCommand[MAX_COMMAND+2] = {'\0'};

    const jchar *jCommandChars
        = pIenv -> GetStringChars(jCommand, NULL);

    for (int i = 0; i<uLength; i++)
        uCommand[i] = jCommandChars[i];

    pIenv -> ReleaseStringChars(jCommand, jCommandChars);

    int rc = _wsystem(uCommand);

    if (rc < 0)
         rc = -errno;

    return rc;

    } /* doCommand */


/* 0.01 2007-02-12-18:22 Switch to using a Unicode system command.
   0.00 2007-01-24-14:21 Implement doCommand for launching programs
        in the confirmation checking of odmjni100.

   $Header: /ODMdev/info/odma/odmjni100/test/Check04/CheckUtil.cpp 2     07-02-12 19:53 Orcmid $
   */

/*                       *** end of CheckUtil.cpp ***                 */
