@echo off
rem BuildCheckNew.bat 0.00           UTF-8                   dh:2007-01-24
ECHO **   BuildCheckNew.bat 0.00 COMPILING odmjni100 CONFIRMATION TEST
ECHO:         This Java application exercises the basic functions of
ECHO:         of the odmjni100 0.50beta classes to confirm correct creation
ECHO:         and use of a new document.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 1 GOTO :Compile
ECHO **   BuildCheckNew.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST CheckNew.java GOTO :FAIL1

erase CheckNew.class CheckUtil.class
SET ERRORLEVEL=
javac -cp ".;%OdmClasses%" CheckNew.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   CheckNew.class COMPILED
ECHO **   ***********************
echo:
echo:     There are no errors or warnings.  This program can be run
echo:     via RunCheckNew.bat.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildCheckNew.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding BuildCheckNew.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE CheckNew.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       BuildCheckNew.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildCheckNew into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA CLASS TO CONFIRM BASIC odmjni100 NEW-DOCUMENT CREATION

rem 0.00 2007-01-23-18:18 Customize from BuildCheckChoice.bat 0.01

rem $Header: /ODMdev/info/odma/odmjni100/test/Check04/BuildCheckNew.bat 1     07-01-25 16:03 Orcmid $

rem                     *** end of BuildCheckNew.bat ***