/* CheckNew.java 0.01                UTF-8                   dh:2007-11-16
 *
 *              DEMONSTRATE THE odmjni100 NEW-DOCUMENT CREATION
 *              ***********************************************
 *
 * The basic exercise consists of creating a document via the
 * OdmConnection.acceptNewDocument() method, then creating a new
 * text file and saving it to the DMS via OdmPendingDocument.commitContent.
 * The OdmWorkingDocument interface that is returned from commitContent()
 * is then exercised as working document in the same basic manner as after
 * a chooseDocument operation.
 */

 import info.odma.practical100.*;

 import info.odma.odmjni100.*;

 class CheckNew
 {  /* PROVIDE OPERATIONAL DEMONSTRATION OF ODMJNI DOCUMENT CREATION.
       */


    /* AUXILLIARY OUTPUT PRESENTATION OPERATIONS
       ***************************************** */


    private static final java.lang.String indent = "          ";
            /* Indent below the                    "CheckNew> ". */

    private static final java.lang.String stars =  "     **** ";
            /* Used to highlight unexpected results */


    private static void hello(IConOut console)
    {   /* Identify the application and what we are doing here.
           */

        console.println();
        console.println(   "CheckNew> 0.01 Explore acceptNewDocument() "
                           + " (using JNI " + OdmJniBind.getVersion()
                           + ")"
                           );

        } /* hello */



    private static void reportConnectionDrop(   IConOut  console,
                                                boolean  hasConnection
                                                )
    {   /* If there is a connection, report on its release */

        if (!hasConnection) return;

        console.println();
        console.println(indent
                        + "> > The Connection is no longer required.\n"
                        + indent
                        + "    It is released by OdmConnection.release()."
                        );

        } /* reportConnectionDrop */



    private static void reportRelease(IConOut console)
    {   /* Simply report that the symmetrical release case
           has happened.
           */

        console.println();
        console.println(indent + "> Interface OdmConnection.release() "
                               + "performed.");
        } /* reportRelease */



    private static void reportDefaultDropped
                            (  IConOut console,
                               boolean nowDefault
                               )
    {   /* Confirm that the default is no longer available. */

        if (!nowDefault)
             console.println(indent + "  The Default DMS is no longer "
                                    + "available."
                                    );

        else console.println(stars + "THE DEFAULT DMS DIDN'T DROP.");

        } /* reportDefaultDropped */



    private static void reportConDropped(  IConOut console,
                                           boolean nowConnected
                                           )
    {   /* Confirm that the connection is no longer available. */

        if (!nowConnected)
             console.println(indent + "  The connection is no longer "
                                    + "available."
                                    );

        else console.println(stars + "THE CONNECTION FAILED TO DROP.");

        } /* reportConDropped */



    private static void goodbye(IConOut console)
    {   /* Announce completion of operation */

        console.println();
        console.println("CheckNew> exit");
        console.println();
        } /* goodbye */



    private static final IConLineIO stdio = new ConLineIO();
            /* Use a default console input-output implementation */

    private static final IConOut stdout = stdio;

    private static final IConLineIn stdin = stdio;


    /* THE MAIN PROCEDURE AND ITS SUBORDINATE OPERATIONS
       ************************************************* */


    public static void main(String[] args)
    {   /* Exercise enough of OdmJniBind to confirm that we have
           basic connection and OdmNative access. */

        hello(stdout);

        OdmConnection OdmApp = OdmJniBind.application("OdmNativeTest");

        CheckUtil.reportInterface(stdout, indent,
                                  OdmApp.interfaceImplementation() );

        boolean haveConnection = OdmApp.available();

        CheckUtil.reportConnection(stdout, indent, haveConnection);

        boolean haveDefaultDMS = OdmApp.dmsDefaultAvailable();

        if (!haveConnection)
             {  CheckUtil.reportExpectedNoDefault(stdout,
                                                  "    " + indent,
                                                  "    " + stars,
                                                  haveDefaultDMS
                                                  );
                haveDefaultDMS = false;
                    /* forcing consistency after possible problem. */
                }

        else CheckUtil.reportAvailabilityDefaultDMS(stdout,
                                                    indent + "      ",
                                                    indent + "> > > ",
                                                    haveDefaultDMS
                                                    );

        info.odma.practical100.OdmPendingDocument pend = null;
            /* reference to result of acceptNewDocument(), if any.
               */

        info.odma.practical100.OdmWorkingDocument work = null;
            /* reference to result of commitContent(), if any.
               */

        final java.lang.String docIndent = indent + "        ";
        final java.lang.String docSlider = indent + "> > > > ";

        boolean proceedOK = false;

        if (haveDefaultDMS)
             {  /* Let's go after a New Document */
                pend = OdmApp.acceptNewDocument(".txt");
                CheckUtil.reportPendingResult(stdout,
                                              docIndent,
                                              docSlider,
                                              pend
                                              );

                proceedOK = pend.operationSucceeded();
                }

        java.lang.String resp = "N";

        if (proceedOK)
             {  CheckUtil.doCommand("start Notepad "
                                    + pend.docSubmissionLocation()
                                    );
                stdout.println();
                stdout.print(docIndent
                             + "Commit Content? ([y]/N): "
                             );
                stdout.flush();

                try { resp = stdin.readLine();
                      }
                catch (java.io.IOException e)
                    { }
                stdout.println();
                if (resp == null)
                     proceedOK = false;
                }

        if (resp.length() > 0)
             if (resp.charAt(0) == 'N'
                   || resp.charAt(0) == 'n')
                  proceedOK = false;

        if (proceedOK)
             {  work = pend.commitContent();
                CheckUtil.reportWorkingResult(stdout,
                                              docIndent,
                                              docSlider,
                                              work
                                              );
                }

        if (proceedOK)
             proceedOK = work.operationSucceeded()
                               && !work.notChangeable();

        while (proceedOK)
            { CheckUtil.doCommand("start Notepad "
                                    + work.docLocation()
                                    );
              stdout.println();
              stdout.print(docIndent
                             + "Commit Changes? ([y]/N): "
                             );
              stdout.flush();
              resp = "N";
              try { resp = stdin.readLine();
                    }
              catch (java.io.IOException e)
                  { }
              stdout.println();
              if (resp == null)
                   break;
              if (resp.length() > 0)
                   if (resp.charAt(0) == 'N'
                         || resp.charAt(0) == 'n')
                        break;

              boolean changed = work.commitChanges();
              stdout.println(docIndent
                                    + "commitChanges reports "
                                    + changed
                                    );
              stdout.println();
              CheckUtil.showProperties(stdout, docIndent, work);
              }

        if (pend != null)
             pend.release();
        if (work != null)
             work.release();

        CheckUtil.reportDefaultDrop(stdout, indent, haveDefaultDMS);

        CheckUtil.reportConnectionDrop(stdout, indent, haveConnection);

        OdmApp.release();
        reportRelease(stdout);
        if (haveDefaultDMS)
             CheckUtil.reportDefaultDropped
                                 (  stdout, indent, stars,
                                    OdmApp.dmsDefaultAvailable()
                                    );
        if (haveConnection)
             CheckUtil.reportConDropped
                                 (  stdout, indent, stars,
                                    OdmApp.available()
                                    );

        goodbye(stdout);

        } /* main */



    } /* CheckNew */


/* 0.01 2007-11-16-18:43 Replace viewOnly check with notChangeable
   0.00 2007-01-24-21:12 Derived by modification of CheckChoice 0.16.

   $Header: /ODMdev/info/odma/odmjni100/test/check04/CheckNew.java 2     07-11-16 18:44 Orcmid $
   */

/*                         *** end of CheckNew.java ***                 */
