/* odma.h - Definitions, prototypes, etc. for Open Document Managment API
	(ODMA) version 1.0.

	COPYRIGHT (C) 1994, 1995
	AIIM International
	All Right Reserved
*/

#ifndef ODMA_H
#define ODMA_H

/* Type definitions */
typedef LPVOID ODMHANDLE;
typedef LPSTR (*ODMSAVEASCALLBACK)(DWORD dwEnvData, LPSTR lpszFormat, LPVOID pInstanceData);
typedef int ODMSTATUS;

/* Constants */
#define ODM_API_VERSION			100		/* Version of the API */

#ifdef WIN32
	#define ODM_DOCID_MAX		255		/* Win32 */
#elif defined( _WINDOWS_ ) || defined( _MSDOS )
	#define ODM_DOCID_MAX		80			/* Windows 3.x */
#else
	#define ODM_DOCID_MAX		255		/* Other platforms */
#endif

#define ODM_DMSID_MAX			9			/* Max length of a DMS ID including the */
													/* terminating NULL character. */


/* Maximum length of a filename returned by ODMA including the terminating
	NULL character.  Platform dependent. */

#ifdef WIN32
	#define ODM_FILENAME_MAX	255		/* Win32 */
#elif defined( _WINDOWS_ ) || defined( _MSDOS )
	#define ODM_FILENAME_MAX	128		/* Windows 3.x */
#elif defined( unix ) || defined( _UNIX )
	#define ODM_FILENAME_MAX	1024		/* Unix */
#else
	#define ODM_FILENAME_MAX	255		/* Other platforms */
#endif



/* Common format type names */
#define ODM_FORMAT_TEXT	"Text"
#define ODM_FORMAT_RTF	"Rich text format"
#define ODM_FORMAT_DCA	"DCA RFT"		/* IBM DCA Rich Format Text */
#define ODM_FORMAT_TIFF	"Tiff"
#define ODM_FORMAT_GIF	"Gif"				/* Compuserve Graphics Interchange Format */
#define ODM_FORMAT_BMP	"Windows bitmap"
#define ODM_FORMAT_PCX	"PCX"
#define ODM_FORMAT_CGM	"CGM"				/* Computer Graphics Metafile */
#define ODM_FORMAT_EXE	"Executable file"
#define ODM_FORMAT_PCL	"PCL"				/* HP Printer Control Language */
#define ODM_FORMAT_PS	"PostScript"


/* Error returns */
#define ODM_E_FAIL         1        /* Unspecified failure */
#define ODM_E_CANCEL       2        /* Action was cancelled at user's request */
#define ODM_E_NODMS        3        /* DMS not registered */
#define ODM_E_CANTINIT     4        /* DMS failed to initalize */
#define ODM_E_VERSION      5        /* DMS doesn't support the requested 
                                       version of ODMA */
#define ODM_E_APPSELECT    6        /* User has indicated that he wants to use 
                                       the application's file selection 
                                       capabilities rather than those of the 
                                       DMS. */
#define ODM_E_USERINT      7        /* Requested action cannot be performed 
                                       without user interaction, but silent 
                                       mode was specified. */
#define ODM_E_HANDLE       8        /* The DMHANDLE argument was invalid. */
#define ODM_E_ACCESS       9        /* User does not have requested access 
                                       rights to specified document. */
#define ODM_E_INUSE       10        /* Document is currently in use and cannot 
                                       be accessed in specified mode. */
#define ODM_E_DOCID       11        /* Invalid document ID */
#define ODM_E_OPENMODE    12        /* The specified action is incompatible 
                                       with the mode in which the document was
                                       opened. */
#define ODM_E_NOOPEN      13        /* The specified document is not open. */
#define ODM_E_ITEM        14        /* Invalid item specifier. */
#define ODM_E_OTHERAPP    15        /* Selected document was for another app. */

/* ODMOpenDoc modes */
#define ODM_MODIFYMODE     1        /* Open document in a modifiable mode. */
#define ODM_VIEWMODE       2        /* Open document in non-modifiable mode. */

/* Actions for ODMActivate */
#define ODM_NONE           0        /* No specific action is requested.  */
#define ODM_DELETE         1        /* Delete the specified document.  */
#define ODM_SHOWATTRIBUTES 2        /* Display the specified document's profile 
                                       or attributes. */
#define ODM_EDITATTRIBUTES 3        /* Edit the specified document's profile or
                                       attributes. */
#define ODM_VIEWDOC        4        /* Display the specified document in a 
                                       viewer window. */
#define ODM_OPENDOC        5        /* Open the specified document in its 
                                       native application.  */

/* Item selectors for ODMGetDocInfo and ODMSetDocInfo */
#define ODM_AUTHOR         1        /* Author of the document. */
#define ODM_NAME           2        /* Descriptive name of the document.  */
#define ODM_TYPE           3        /* Type of the document.  */
#define ODM_TITLETEXT      4        /* Suggested text to display in the 
                                       document window's title bar. */
#define ODM_DMS_DEFINED    5        /* DMS defined data. */
#define ODM_CONTENTFORMAT  6        /* String describing document's format */

/* Misc. modes, flags */
#define ODM_SILENT        16        /* Don't interact with the user while
                                       fulfilling this request. */

/* Function prototypes */
#ifdef __cplusplus
extern "C" {
#endif

ODMSTATUS WINAPI ODMRegisterApp(ODMHANDLE FAR *pOdmHandle, WORD version,
	LPSTR lpszAppId, DWORD dwEnvData, LPVOID pReserved);

void WINAPI ODMUnRegisterApp(ODMHANDLE odmHandle);

ODMSTATUS WINAPI ODMSelectDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
	LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMOpenDoc(ODMHANDLE odmHandle, DWORD flags,
	LPSTR lpszDocId, LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMSaveDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
	LPSTR lpszNewDocId);

ODMSTATUS WINAPI ODMCloseDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
	DWORD activeTime, DWORD pagesPrinted, LPVOID sessionData, WORD dataLen);

ODMSTATUS WINAPI ODMNewDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
	DWORD dwFlags, LPSTR lpszFormat, LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMSaveAs(ODMHANDLE odmHandle, LPSTR lpszDocId,
	LPSTR lpszNewDocId, LPSTR lpszFormat, ODMSAVEASCALLBACK pcbCallBack,
	LPVOID pInstanceData);

ODMSTATUS WINAPI ODMActivate(ODMHANDLE odmHandle, WORD action,
	LPSTR lpszDocId);

ODMSTATUS WINAPI ODMGetDocInfo(ODMHANDLE odmHandle, LPSTR lpszDocId,
	WORD item, LPSTR lpszData, WORD dataLen);

ODMSTATUS WINAPI ODMSetDocInfo(ODMHANDLE odmHandle, LPSTR lpszDocId,
	WORD item, LPSTR lpszData);

ODMSTATUS WINAPI ODMGetDMSInfo(ODMHANDLE odmHandle, LPSTR lpszDmsId,
	LPWORD pwVerNo, LPDWORD pdwExtensions);

#ifdef __cplusplus
}
#endif

#endif
