/* odmawf.h - Definitions, prototypes, etc. for Open Document Managment API
	(ODMA) Extensions for Workflow version 1.0.

	Written by D. Hamson, Novell

	COPYRIGHT (C) 1995
	AIIM International
	All Right Reserved
*/

#include "windows.h"
#include "odma.h"

#ifndef ODMAWF_H
#define ODMAWF_H

/* Type definitions */
typedef LPVOID ODMWFHANDLE;

/* Constants */
#define ODMAWF_API_VERSION			100		/* Version of the API */

#define ODMWF_WFID_MAX			255			/* Max length of a workflow id. */

#define ODMWF_WMSID_MAX			9			/* Max length of a Workflow system (WMS) ID */
													/* including the */
													/* terminating NULL character. */
#define ODMWF_APPID_MAX			255			/* Max length of a Appliction Id to be passed as */
											/* input to ODMWFRegisterApp.  This length matches */
											/* the max length of a Windows Registry Key */


/* Error returns */
/* See ODMA.H for additional error returns */

#define ODM_E_NOWMS		  101			/* WMS not registered. */
#define ODM_E_NOATTACH	  102			/* Workflow could not attach document.*/
#define ODM_E_BADWORKFLOW 103			/* No workflow was fetched from inbox. */
#define ODM_E_WORKFLOWID  104			/* Invalid workflow id passed */
#define ODM_E_BADINDEX    105			/* Invalid index to a document passed */
#define ODM_E_NOPERMIT	  106			/* User does not have permission to do action */

/* see ODMA.h for additional selectors */

#define ODM_STATUS			101			/* status of this workflow */
#define ODM_WMS_DEFINED    102        /* WMS defined data. */
#define ODM_ITEMCOUNT		103			/* number of documents associated with
													this Workflow. */
#define ODM_USERID			104			/* ID of the user from Workflow system. */
#define ODM_USERNAME			105			/* Name of the user from WMS. */

/* Misc. modes, flags */
#define ODM_CLOSEDOCS		101			/* Selected documents should be closed */

/* see ODMA.h for additional items */

/* Function prototypes */

#ifdef __cplusplus
extern "C" {
#endif

ODMSTATUS WINAPI ODMWFRegisterApp(ODMWFHANDLE FAR *pOdmwfHandle, WORD version,
	LPSTR lpszAppId, DWORD dwEnvData, LPVOID pReserved);

void WINAPI ODMWFUnRegisterApp(ODMWFHANDLE odmHandle);

ODMSTATUS WINAPI ODMWFNewObject(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMWFSelectObject(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMWFInsertItem(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	WORD wItemNumber, LPSTR lpszDocIdentifier);

ODMSTATUS WINAPI ODMWFRemoveItem(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	WORD wItemNumber);

ODMSTATUS WINAPI ODMWFGetItem(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	WORD wItemNumber, LPSTR lpszDocIdentifier);

ODMSTATUS WINAPI ODMWFProcessObject(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMWFGetObjectInfo(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	WORD attribute, LPSTR lpszData, WORD datalen);

ODMSTATUS WINAPI ODMWFSetObjectInfo(ODMWFHANDLE pOdmwfHandle, LPSTR lpszWorkflowId,
	WORD attribute, LPSTR lpszData);

void WINAPI ODMWFActivate(ODMWFHANDLE pOdmwfHandle, WORD action,
	LPSTR lpszWorkflowId);

void WINAPI ODMWFGetWMSInfo(ODMWFHANDLE pOdmwfHandle, LPSTR wmsId,
	LPWORD pwVerNo, LPDWORD pdwExtensions);

#ifdef __cplusplus
}
#endif

#endif
