/* odmwfcom.h - Component Object Model related definitions, macros, etc. for
	ODMA WF version 1.0.

	COPYRIGHT (C) 1995
	AIIM International
	All Rights Reserved
*/

#ifndef ODMWFCOM_H
#define ODMWFCOM_H

#include "odmawf.h"

#ifdef WIN32
#ifndef _OBJBASE_H_
#include <objbase.h>
#endif /*!_OBJBASE_H_*/
#else
#ifndef _COMPOBJ_H_
#include <memory.h>
#include <compobj.h>
#endif /*!_COMPOBJ_H_*/
#endif /*WIN32*/

#ifndef _OLE2_H_
#include <ole2.h>
#include <moniker.h>
#endif

#ifdef WIN32
#define _export
#endif


// Define the IODMWFWorkMan interface
DEFINE_OLEGUID(IID_IODMWFWorkMan, 0x22FF1L, 0, 0);

#undef  INTERFACE
#define INTERFACE   IODMWFWorkMan

DECLARE_INTERFACE_(IODMWFWorkMan, IUnknown)
{
	// *** IUnknown methods ***
	STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR *ppvObj)  PURE;
	STDMETHOD_(ULONG, AddRef)(THIS) PURE;
	STDMETHOD_(ULONG, Release)(THIS) PURE;

	// *** IODMAWFManager methods ***
	STDMETHOD_(ODMSTATUS, NewObject) (THIS_
		LPSTR lpszWorkflowId,
		LPDWORD pdwFlags) PURE;

	STDMETHOD_(ODMSTATUS, SelectObject) (THIS_
		LPSTR lpszWorkflowId,
		LPDWORD pdwFlags) PURE;

	STDMETHOD_(ODMSTATUS, InsertItem) (THIS_
		LPSTR lpszWorkflowId,
		WORD wItemNumber,
		LPSTR lpszDocIdentifier) PURE;

	STDMETHOD_(ODMSTATUS, RemoveItem) (THIS_
		LPSTR lpszWorkflowId,
		WORD wItemNumber) PURE;

	STDMETHOD_(ODMSTATUS, GetItem) (THIS_
		LPSTR lpszWorkflowId,
		WORD wItemNumber,
		LPSTR lpszDocIdentifier) PURE;

	STDMETHOD_(ODMSTATUS, ProcessObject) (THIS_
		LPSTR lpszWorkflowId,
		LPDWORD pdwFlags) PURE;

	STDMETHOD_(ODMSTATUS, GetObjectInfo) (THIS_
		LPSTR lpszWorkflowId,
		WORD attribute,
		LPSTR lpszData,
		WORD datalen) PURE;

	STDMETHOD_(ODMSTATUS, SetObjectInfo) (THIS_
		LPSTR lpszWorkflowId,
		WORD attribute,
		LPSTR lpszData) PURE;

	STDMETHOD_(void, Activate) (THIS_
   	WORD action,
		LPSTR lpszWorkflowId) PURE;

	STDMETHOD_(void, GetWMSInfo) (THIS_
		LPSTR wmsId,
		LPWORD pwVerNo,
		LPDWORD pdwExtensions) PURE;

};

typedef IODMWFWorkMan FAR * LPODMWFWORKMAN;

#ifdef __cplusplus
extern "C" {
#endif

// ODMA prototypes
HRESULT WINAPI ODMWFQueryInterface(ODMWFHANDLE odmwfHandle, LPSTR lpszWorkflowId,
	REFIID riid, LPVOID FAR *ppvObj);


// Prototype for ODMA provider entry point function
HRESULT WINAPI _export ODMWFGetODMInterface(REFIID riid, LPVOID FAR *ppvObj,
	LPUNKNOWN pUnkOuter, LPVOID pReserved, LPSTR lpszAppId, DWORD dwEnvData);

#ifdef __cplusplus
}
#endif

#endif



