/* wfconman.h - Prototypes, definitions, etc. for the ODMA connection manager.
 *
 * COPYRIGHT (C) 1995
 * AIIM International
 * All Rights Reserved
*/

#include "odmwfcom.h"
#include "odmawf.rh"

#define NC(a,b) a##::##b
#define MAXERRSTRING	120		/* maximum length of error string */

// Node type for linked lists of ODMWms objects.
typedef struct wmslist {
	 class ODMWFWms *pWms;
	 struct wmslist *next;
} WMSList;

/* The ODMWFClient class.  Represents a caller or user of the ODMAWF API. */
class ODMWFClient {
	public:
	ODMWFClient(LPSTR lpszAppId, WORD version, DWORD dwEnvData);
	~ODMWFClient();
	HRESULT WorkflowIdQueryInterface(LPSTR lpszWorkflowId, REFIID riid, LPVOID FAR *ppvObj);

	private:
	//----------------------------------------------------------------
	// IUnknown implementation
	//----------------------------------------------------------------
	struct CUnknown : IUnknown {
		CUnknown(ODMWFClient *pObject) { m_pObject = pObject; }

		//*** IUnknown ***
		STDMETHOD(QueryInterface) (REFIID riid, LPVOID FAR* ppvObj);
		STDMETHOD_(ULONG,AddRef) (VOID);
		STDMETHOD_(ULONG,Release) (VOID);

		private:
		ODMWFClient *m_pObject;	// pointer to parent object
	};

	friend CUnknown;
	CUnknown m_Unknown;

	//----------------------------------------------------------------
	// IODMWFWorkMan implementation
	//----------------------------------------------------------------
	struct CODMWFWorkMan : IODMWFWorkMan {
		CODMWFWorkMan(ODMWFClient *pObject) { m_pObject = pObject; }
		~CODMWFWorkMan() {};

		//*** IUnknown ***
		STDMETHOD(QueryInterface) (REFIID riid, LPVOID FAR* ppvObj);
		STDMETHOD_(ULONG,AddRef) (VOID);
		STDMETHOD_(ULONG,Release) (VOID);

		// *** IODMWFWorkMan methods ***
		STDMETHOD_(ODMSTATUS, NewObject)(LPSTR lpszWorkflowId, LPDWORD pdwFlags);
		STDMETHOD_(ODMSTATUS, SelectObject)(LPSTR lpszWorkflowId, LPDWORD pdwFlags);
		STDMETHOD_(ODMSTATUS, InsertItem) (LPSTR lpszWorkflowId, WORD wItemNumber,
			LPSTR lpszDocIdentifier);
		STDMETHOD_(ODMSTATUS, RemoveItem) (LPSTR lpszWorkflowId, WORD wItemNumber);
		STDMETHOD_(ODMSTATUS, GetItem) (LPSTR lpszWorkflowId, WORD wItemNumber,
			LPSTR lpszDocIdentifier);
		STDMETHOD_(ODMSTATUS, ProcessObject) (LPSTR lpszWorkflowId, LPDWORD pdwFlags);
		STDMETHOD_(ODMSTATUS, GetObjectInfo) (LPSTR lpszWorkflowId, WORD attribute,
			LPSTR lpszData, WORD datalen);
		STDMETHOD_(ODMSTATUS, SetObjectInfo) (LPSTR lpszWorkflowId, WORD attribute,
			LPSTR lpszData);
		STDMETHOD_(void, Activate) (WORD action, LPSTR lpszWorkflowId);
		STDMETHOD_(void, GetWMSInfo) (LPSTR wmsId, LPWORD pwVerNo,
			LPDWORD pdwExtensions);

		private:
		ODMWFClient *m_pObject;					// pointer to parent object
	};

	friend CODMWFWorkMan;

	public:
	CODMWFWorkMan m_ODMWFWorkMan; /* has to be public for ODMA WF entry functions to
										 access it. */

	friend ODMSTATUS WINAPI ODMWFRegisterApp(ODMWFHANDLE FAR *pOdmwfHandle, WORD
		version, LPSTR lpszAppId, DWORD dwFlags, LPVOID pReserved);

	private:
	// Internal functions.
	ODMSTATUS ConnectWorkflowId(LPSTR lpszWorkId, ODMWFWms **ppWms);
	ODMSTATUS ConnectWms(LPSTR lpszWmsId, ODMWFWms **ppWms);

	// Internal data
	DWORD m_dwRefs;					// reference count
	WORD m_version;					// version of the API that this client expects to see
	HWND m_clientWind;				// client's window handle
	char m_appid[ODMWF_APPID_MAX];	// application ID of the client
	class ODMWFWms *m_pDefaultWms;	// default WMS for this client
	WMSList *m_otherWmss;			// list of implicitly connected WMSs

};	/* ODMWFClient */


/* The ODMA WF Registry class.  Represents the registry of information about which
	WMSs should be used with which applications. */
class ODMWFRegistry {
	private:

	public:
	ODMWFRegistry(){};
	~ODMWFRegistry(){};
	int GetDefaultWmsId(LPSTR lpszAppId, LPSTR lpszWmsId);
	int GetWMSEntry(LPSTR lpszWmsId, LPSTR lpszWMSEntry, int entryLen);
};

extern class ODMWFRegistry Registry;


// The ODMWFWms class.  Represents a WMS that is acting as an ODMA provider.
class ODMWFWms {
	private:
	char Id[ODMWF_WMSID_MAX]; /* We could ask the DMS for it, but it's used often
								so for efficiency we'll cache it here. */
	HINSTANCE hWms;         /* Handle to the DMS's DLL. */

	public:
	ODMWFWms();
	~ODMWFWms();
	ODMSTATUS Init(LPSTR lpszWmsId, LPSTR lpszAppId, WORD version,
		LPUNKNOWN pUnkOuter, DWORD dwEnvData);
	char * GetId(void)		// Return a pointer to the WMS ID string.
		{ return Id; };      // The caller should not alter this string; it is
									// to be considered view-only.
	LPUNKNOWN m_pWmsUnk;		// The WMS's IUnknown interface.
	LPODMWFWORKMAN WorkMan;		// IODMWFWorkMan interface from the WMS.

};


// Globals
extern HINSTANCE hInst;

// Prototypes
void ErrorMessage(UINT stringId);

