#------------------------------------------------------------
# WFS16.MAK   Makefile for MSVC 1.5x Compilers
#
# Builds WFCLIENT.EXE (the 16-bit Workflow Client)
#------------------------------------------------------------

#===== NAME OF PROJECT =====
PROJ = WFCLIENT
PROJ_DIR = s:\odmawf\wfclient
OUTDIR = S:\ODMAWF\WFCLIENT\OUT16^\




#===== WHERE ARE YOUR MSVC BINARIES =====
BIN = d:\msvc\bin


#===== INCLUDE DIRECTORIES =====
INCLUDE = d:\msvc\include
WF_INC = s:\odmawf\odmawf^\

#===== LIB DIRECTORIES =====
LIB = d:\msvc\lib
MFC_LIB = d:\msvc\mfc\lib
ODMAWF_LIB = ..\ODMAWF\OUT16


#===== COMPILER & OPTIONS =====
CC = $(BIN)\cl /I$(INCLUDE) /I$(WF_INC)
CFLAGS = /nologo /G2 /W3 /Zi /AL /Od /D "_DEBUG" /Fd"out16/WFCLIENT.PDB" /FR"out16/" /GA


#===== RESOURCE COMPILER & OPTIONS =====
RC = $(BIN)\rc
RC_FLAGS = /fo.\out16/wfclient.res


#===== LINK & OPTIONS =====
LINK = $(BIN)\link
L_FLAGS = /NOLOGO /NOD /PACKC:61440 /STACK:10240 /ALIGN:16 /ONERROR:NOEXE /CO



#===== BSCMAKE & OPTIONS =====
BSCMAKE = $(BIN)\bscmake
BSC_FLAGS = /o$(OUTDIR)"wfclient.bsc"


#===== IMPLIB =====
IMPLIB = $(BIN)\implib


LIBS = oldnames.lib libw.lib mlibcew.lib ..\odmawf\out16\odmawf.lib commdlg.lib olecli.lib olesvr.lib shell.lib
DEFFILE = wfc16.def
MAPFILE = nul

!if [if exist $(OUTDIR)MSVC.BND del $(OUTDIR)MSVC.BND]
!endif

SBRS   = $(OUTDIR)WFCLIENT.SBR \
         $(OUTDIR)WFCWF.SBR

         
L_OBJS = $(OUTDIR)WFCLIENT.OBJ \
         $(OUTDIR)WFCWF.OBJ
         
         
#----- DEPENDENCIES FOR SOURCE FILES -----
DEP = $(WF_INC)odmawf.h \
      $(WF_INC)odma.h \
      wfclient.h


ALL : $(OUTDIR)WFCLIENT.EXE $(OUTDIR)WFCLIENT.BSC

$(OUTDIR)WFCLIENT.OBJ: WFCLIENT.CPP $(DEP)
	$(CC) $(CFLAGS) /Fo$(OUTDIR) /c WFCLIENT.CPP
      
$(OUTDIR)WFCWF.OBJ: WFCWF.CPP $(DEP)
	$(CC) $(CFLAGS) /Fo$(OUTDIR) /c WFCWF.CPP
     
$(OUTDIR)WFCLIENT.RES: WFCLIENT.RC
	$(RC) /r /d_DEBUG $(RC_FLAGS) /I$(INCLUDE) WFCLIENT.RC
	

	
$(OUTDIR)WFCLIENT.EXE:: $(OUTDIR)WFCLIENT.RES

$(OUTDIR)WFCLIENT.EXE:: $(L_OBJS) $(OUTDIR)WFCLIENT.RES $(DEFFILE)
	echo >nul @<<WFC16.CRF
$(OUTDIR)WFCLIENT.OBJ +
$(OUTDIR)WFCWF.OBJ
$(OUTDIR)WFCLIENT.EXE
$(OUTDIR)$(MAPFILE)
$(LIB)\+
$(MFC_LIB)\+
$(LIBS)
$(DEFFILE);
<<
   $(LINK) $(L_FLAGS) @WFC16.CRF
   $(RC) /I$(INCLUDE) $(OUTDIR)WFCLIENT.RES $@
   @copy WFC16.CRF $(OUTDIR)MSVC.BND
                           
                           
$(OUTDIR)WFCLIENT.EXE:: $(OUTDIR)WFCLIENT.RES
	if not exist $(OUTDIR)MSVC.BND  $(RC) $(RES_FLAGS) $(OUTDIR)WFCLIENT.RES $@
        
run: $(OUTDIR)WFCLIENT.EXE
		$(OUTDIR)WFCLIENT                          

$(OUTDIR)WFCLIENT.BSC: $(SBRS)
  $(BSCMAKE) @<<
$(BSC_FLAGS) $(SBRS)
<<
