/* wfclient.cpp - Entry point, initialization, cleanup, main window proc, 
 *	etc. for ODMA WF sample client.
 *
 * Written by D. Hamson, Novell
 * Revised by M. Gardiner, Novell
 *
 * COPYRIGHT (C) 1995
 * AIIM International
 * All Rights Reserved
 */




#include <windows.h>
#include "odmawf.h"
#include "wfclient.h"


// Internal prototypes

BOOL WINAPI InitApp();
BOOL WINAPI InitInstance();
LONG WINAPI WFMainWndProc(HWND,UINT,WPARAM,LPARAM);
BOOL WINAPI AboutProc(HWND  hwndDlg,UINT  uMsg,WPARAM  wParam,LPARAM  lParam);

// Global variables
ODMWFHANDLE odmwfHandle;   // handle to odmawf session
HINSTANCE hInst;
HWND lwnd;					// handle to log window
char lbuf[80];				// buffer for putting to the log window


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
LPSTR lpszCmdLine, int nCmdShow)
{
	MSG msg;

	hInst = hInstance;

	/* If first instance, register window class(es) */
	if (!hPrevInstance) {
		if (!InitApp())
			return 0;
	}

	if (!InitInstance())
		return 0;

	while (GetMessage(&msg,NULL,0,0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return(msg.wParam);
}

// Register window class for this sample app.
BOOL WINAPI InitApp()
{
	WNDCLASS wc;

	wc.style				= 0;
	wc.lpfnWndProc		= WFMainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInst;
	wc.hIcon				= NULL;
	wc.hCursor			= LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground	= (HBRUSH)(COLOR_APPWORKSPACE + 1);
	wc.lpszMenuName 	= MAKEINTRESOURCE(MAIN_MENU);
	wc.lpszClassName	= "wfmain";

	if (!RegisterClass(&wc))
		return FALSE;

	return TRUE;
}


// Create main window and log window.
// Also, register with odmawf.
BOOL WINAPI InitInstance()
{
	HWND hwnd;
	ODMSTATUS err;

	// main application window creation
	hwnd = CreateWindow("wfmain", "ODMAWF Sample Client",
				WS_OVERLAPPEDWINDOW,
				CW_USEDEFAULT, 0,
				CW_USEDEFAULT, 0,
				NULL, NULL, hInst, NULL);
				
	if(!hwnd)
		return FALSE;
		
	ShowWindow(hwnd,SW_SHOWMAXIMIZED);
	UpdateWindow(hwnd);

	// log window creation.  The log window is implemented as a list box.
	lwnd = CreateWindow("LISTBOX","ODMA WF Call Log",WS_OVERLAPPEDWINDOW,300,50,
				335,400,hwnd,NULL,hInst,NULL);

	if(lwnd) {
		ShowWindow(lwnd,SW_SHOW);
		UpdateWindow(lwnd);
	}

	// register with odmawf
	if((err = ODMWFRegisterApp(&odmwfHandle, ODMAWF_API_VERSION, "wfclient", (DWORD)hwnd, NULL))) {
		odmwfHandle = NULL;
	}
	
	wsprintf(lbuf,"ODMWFRegisterApp returned: %d",err);
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);

	return TRUE;
}

// proc for main window; dispatches menu choices to functions in wfcwf.cpp
LONG WINAPI WFMainWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg) {
		case WM_COMMAND:
			switch(GET_WM_COMMAND_ID(wParam,lParam)) {
				case IDM_EXIT:
					SendMessage(hwnd,WM_CLOSE,0,0L);
					break;
					
				case IDM_ATTACHWF:
					AttachWorkflow();
					break;
					
				case IDM_INBOXWF:
					WorkflowInbox();
					break;
					
				case IDM_PROCESSWF:
					ProcessWorkflow();
					break;
					
				case IDM_ATTACHDOC:
					AttachDocument();
					break;
					
				case IDM_GETDOCS:
					GetDocuments();
					break;
					
				case IDM_EDITPROPS:
					EditProps(hwnd);
					break;
					
				case IDM_REMOVEDOC:
					RemoveDoc();
					break;
					
				case IDM_WFACTIVATE:
					ActivateWMS();
					break;
					
				case IDM_WFEDIT:
					EditWorkflow();
					break;
					
				case IDM_WFSHOW:
					ShowWorkflow();
					break;
					
				case IDM_WFDELETE:
					DeleteWorkflow();
					break;
					
				case IDM_ABOUT:
					FARPROC lpfnDlgAbout;
					
					lpfnDlgAbout = MakeProcInstance((FARPROC)AboutProc, hInst);
					DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUT), hwnd, (DLGPROC)AboutProc);
#ifndef WIN32
					FreeProcInstance(lpfnDlgAbout);
#endif					
					break;
					
				case IDM_WMS: 
					ShowWMSInfo(hwnd);
					break;
			}
			break;
			
		case WM_CLOSE:
			DestroyWindow(hwnd);
			if (odmwfHandle)
				ODMWFUnRegisterApp(odmwfHandle);
			break;
			
		case WM_ENDSESSION:
			if (wParam != 0) {
				if (odmwfHandle)
					ODMWFUnRegisterApp(odmwfHandle);
			}
			
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
			
		default:
			return DefWindowProc(hwnd,msg,wParam,lParam);
	}
	return 0;
}

// proc for the Help About box;  very simple
BOOL WINAPI AboutProc(HWND  hDlg,UINT  uMsg,WPARAM  wParam,LPARAM  lParam)
{
	switch(uMsg) {
		case WM_COMMAND:
			switch(wParam) {
			 	case IDOK:
					EndDialog(hDlg,NULL);
					return(TRUE);
			}
		break;			
	}
	return(FALSE);
}

