/* wfclient.h - Header for sample client for ODMA WF.
 *
 * Written by D. Hamson, Novell
 * Revised by M. Gardiner, Novell
 *
 * COPYRIGHT (C) 1995
 * AIIM International
 * All Rights Reserved
 */
 
#ifndef WFCLIENT_H
#define WFCLIENT_H

#include <windows.h>

#define ID(id) MAKEINTRESOURCE(id)

#define MAIN_MENU                       1
#define IDM_EXIT                        101
#define IDD_PROPS                       101
#define IDD_ABOUT                       102
#define IDD_WMS                         103
#define IDM_ATTACHWF                    201
#define IDM_INBOXWF                     202
#define IDM_PROCESSWF                   203
#define IDM_ATTACHDOC                   204
#define IDM_GETDOCS                     205
#define IDC_AUTHOR                      1000
#define IDC_NAME                        1001
#define IDC_STATUS                      1002
#define IDC_TITLETEXT                   1003
#define IDC_ITEMCOUNT                   1004
#define IDC_USERID                      1005
#define IDC_USERNAME                    1006
#define IDC_WMSID                       1007
#define IDC_VERSION                     1008
#define IDC_EXTENSION                   1009
#define IDM_EDITPROPS                   40001
#define ID_WORKFLOW_REMOVEDOCUMENT      40002
#define IDM_REMOVEDOC                   40002
#define IDM_ABOUT                       40003
#define IDM_WMS                         40004
#define IDM_WFDELETE                    40006
#define IDM_WFSHOW                      40007
#define IDM_WFACTIVATE                  40008
#define IDM_WFEDIT                      40010
#define IDC_STATIC                      -1

// Message crackers for 16 & 32 compatibility
#ifdef WIN32
#ifndef GET_WM_COMMAND_CMD
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(wp)
#endif
#ifndef GET_WM_COMMAND_ID
#define GET_WM_COMMAND_ID(wp, lp)   LOWORD(wp)
#endif
#ifndef GET_WM_COMMAND_HWND
#define GET_WM_COMMAND_HWND(wp, lp) (HWND)lp)
#endif
#else
#ifndef GET_WM_COMMAND_CMD
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(lp)
#endif
#ifndef GET_WM_COMMAND_ID
#define GET_WM_COMMAND_ID(wp, lp)   (wp)
#endif
#ifndef GET_WM_COMMAND_HWND
#define GET_WM_COMMAND_HWND(wp, lp) ((HWND)LOWORD(lp))
#endif
#endif


// Prototypes for internal work functions
void AttachWorkflow(void);
void WorkflowInbox(void);
void ProcessWorkflow(void);
void AttachDocument(void);
void GetDocuments(void);
void EditProps(HWND hwnd);
void ShowWMSInfo(HWND hwnd);
void RemoveDoc(void);
void ActivateWMS(void);
void EditWorkflow(void);
void ShowWorkflow(void);
void DeleteWorkflow(void);

#endif //WFCLIENT_H


