/* wfcwf.cpp - Functions to handle menu items.  Most
 *	of the ODMAWF calls are made here.
 *
 * Written by D. Hamson, Novell
 * Revised by M. Gardiner, Novell
 *
 * COPYRIGHT (C) 1995
 * AIIM International
 * All Rights Reserved
 */


#include <windows.h>
#include <dos.h>
#include "odmawf.h"
#include "wfclient.h"

// Global variables declared in wfclient.cpp
extern ODMWFHANDLE odmwfHandle;
extern HINSTANCE hInst;
extern HWND lwnd;
extern char lbuf[80];

// Globals used to track the current workflow
char lpszWorkflowId[ODMWF_WFID_MAX];
char author[30];
char name[80];
char status[30];
char titletext[80];
char itemcount[10];
char userid[20];
char username[50];

// Globals used to track the current WMS
WORD verno;
DWORD extensions;
char wmsid[10];
char version[10];
char extens[15];

// Internal prototypes
BOOL WINAPI PropsDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI WMSProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Requests a new workflow id from the WMS.
// (The workflow does not start until a call to
//  ODMWFProcessObject is made.)
void AttachWorkflow(void)
{
	ODMSTATUS err;

	err = ODMWFNewObject(odmwfHandle,lpszWorkflowId, 0);
	// log result
	wsprintf(lbuf,"ODMWFNewObject returned: %d",err);
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
	if (!err) {
		wsprintf(lbuf,"Workflow Id: %s",lpszWorkflowId);
		SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
	}

}

// Requests the display of the WMS's inbox.
// If a workflow is selected, the workflow id is returned.
void WorkflowInbox(void)
{
	ODMSTATUS err;
	DWORD flags=0;

	err = ODMWFSelectObject(odmwfHandle,lpszWorkflowId,&flags);
	// log result
	wsprintf(lbuf,"ODMWFSelectObject returned: %d",err);
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
	if (!err) {
		wsprintf(lbuf,"Workflow Id: %s",lpszWorkflowId);
		SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
	}

}

// Move the workflow to the next state.  This is how
// a new workflow is started and how a user declares
// that they are done with the current step.
void ProcessWorkflow(void)
{
	ODMSTATUS err;

	err = ODMWFProcessObject(odmwfHandle,lpszWorkflowId, 0);
	// log result 
	wsprintf(lbuf,"ODMWFProcessObject returned: %d",err);
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
	wsprintf(lbuf,"Workflow Id: %s",lpszWorkflowId);
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
}

// This call adds a document to the workflow. This sample
// uses a fake odma document id.
void AttachDocument(void)
{
	ODMSTATUS err;
	char DocId[ODM_DOCID_MAX];
#ifdef WIN32
	SYSTEMTIME tm;
#elif __BORLANDC__
	struct time tm;
#else
	struct _dostime_t tm;
#endif


/* Make up a fake ODMA document Id which is used to represent a document
	to the WMS. */
#ifdef WIN32
	GetLocalTime(&tm);

	if (tm.wMilliseconds > 99)
		tm.wMilliseconds /= 10;

	wsprintf(DocId,"::ODMA\\NOTREAL\\%02d-%02d-%02d-%02d",tm.wHour,tm.wMinute,tm.wSecond,tm.wMilliseconds);
#elif __BORLANDC__
	gettime(&tm);
	wsprintf(DocId,"::ODMA\\NOTREAL\\%02d-%02d-%02d-%02d",tm.ti_hour,tm.ti_min,tm.ti_sec,tm.ti_hund);
#else
	_dos_gettime(&tm);
	wsprintf(DocId,"::ODMA\\NOTREAL\\%02d-%02d-%02d-%02d",tm.hour,tm.minute,tm.second,tm.hsecond);
#endif
	// add the document to the workflow
	err = ODMWFInsertItem(odmwfHandle,lpszWorkflowId,0,DocId);
	// log result
	wsprintf(lbuf,"ODMWFInsertItem returned: %d",err);
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
	if (!err) {
		wsprintf(lbuf,"Document Id: %s",DocId);
		SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
	}

	return;
}

//  Get all of the documents associated with the current workflow.
//  (The number of documents associated with the current workflow
//   can be determined by calling ODMWFGetObjectInfo.)
void GetDocuments(void)
{
	ODMSTATUS err;
	int i=0;
	char DocId[ODM_DOCID_MAX];

	// loop until there are no more documents
	do {
		err = ODMWFGetItem(odmwfHandle,lpszWorkflowId,i,DocId);
		// log results
		wsprintf(lbuf,"ODMWFGetItem returned: %d",err);
		SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
		if (!err) {
			wsprintf(lbuf,"Document Id: %s",DocId);
			SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
		}
		i++;
	} while (!err);

	return;
}

// Removes the first document from the documents
// associated with the current workflow.
void RemoveDoc(void)
{
	ODMSTATUS err;

	err = ODMWFRemoveItem(odmwfHandle,lpszWorkflowId, 0);
	// log result
	wsprintf(lbuf,"ODMWFRemoveItem returned: %d",err);
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
}

// Activate the WMS, with no particular action in mind.
void ActivateWMS(void)
{
	ODMWFActivate(odmwfHandle,ODM_NONE,lpszWorkflowId);
	// log call
	wsprintf(lbuf,"ODMWFActivate called with ODM_NONE");
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
}

// Ask the WMS to display the current workflow's properties.
void ShowWorkflow(void)
{
	ODMWFActivate(odmwfHandle,ODM_SHOWATTRIBUTES,lpszWorkflowId);
	// log call
	wsprintf(lbuf,"ODMWFActivate called with ODM_SHOWATTRIBUTES");
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
}

//  Ask the WMS to all the user to edit the current workflow's
//  properties.
void EditWorkflow(void)
{
	ODMWFActivate(odmwfHandle,ODM_EDITATTRIBUTES,lpszWorkflowId);
	// log call
	wsprintf(lbuf,"ODMWFActivate called with ODM_EDITATTRIBUTES");
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
}

//  Ask the WMS to delete the current workflow.
void DeleteWorkflow(void)
{
	ODMWFActivate(odmwfHandle,ODM_DELETE,lpszWorkflowId);
	// log call  (No error can be returned!)
	wsprintf(lbuf,"ODMWFActivate called with ODM_DELETE");
	SendMessage(lwnd,LB_ADDSTRING,0,(LPARAM)(char far *)lbuf);
}

//  Show the current workflow's properties as available
//  to the application.  Allow the changable ones to be
//  edited and push the changes to the WMS.
void EditProps(HWND hwnd)
{
FARPROC lpfnDlg;

	lpfnDlg = (FARPROC) MakeProcInstance((FARPROC)PropsDialogProc, hInst);
	DialogBox(hInst, MAKEINTRESOURCE(IDD_PROPS), hwnd, (DLGPROC)lpfnDlg);
#ifndef WIN32
	FreeProcInstance(lpfnDlg);
#endif
	return;
}

//  proc for showing and editing the workflow properties.
BOOL WINAPI PropsDialogProc(HWND  hDlg,UINT  uMsg,WPARAM  wParam,LPARAM  lParam)
{

	switch(uMsg) {
	 	case WM_COMMAND:
			switch(GET_WM_COMMAND_ID(wParam,lParam)) {
				case IDOK:
					//  push changes back to the WMS
					GetDlgItemText(hDlg, IDC_AUTHOR,author,sizeof(author));
					ODMWFSetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_AUTHOR,author);
					GetDlgItemText(hDlg, IDC_NAME, name, sizeof(name));
					ODMWFSetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_NAME,name);
					EndDialog(hDlg,NULL);
					return(TRUE);
				case IDCANCEL:
					EndDialog(hDlg,NULL);
					return(TRUE);
			}
			break;
		case WM_INITDIALOG:
			// get current properties for display
			ODMWFGetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_AUTHOR,author,sizeof(author));
			SetDlgItemText(hDlg, IDC_AUTHOR, author);
			ODMWFGetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_NAME,name,sizeof(name));
			SetDlgItemText(hDlg, IDC_NAME, name);
			ODMWFGetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_STATUS,status,sizeof(status));
			SetDlgItemText(hDlg, IDC_STATUS, status);
			ODMWFGetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_TITLETEXT,titletext,sizeof(titletext));
			SetDlgItemText(hDlg, IDC_TITLETEXT, titletext);
			ODMWFGetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_ITEMCOUNT,itemcount,sizeof(itemcount));
			SetDlgItemText(hDlg, IDC_ITEMCOUNT, itemcount);
			ODMWFGetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_USERID,userid,sizeof(userid));
			SetDlgItemText(hDlg, IDC_USERID, userid);
			ODMWFGetObjectInfo(odmwfHandle,lpszWorkflowId,ODM_USERNAME,username,sizeof(username));
			SetDlgItemText(hDlg, IDC_USERNAME, username);
			SetFocus(GetDlgItem(hDlg,IDC_AUTHOR));
			return(FALSE);
			break;
	}

	return(FALSE);

}


//  Show information about the WMS
void ShowWMSInfo(HWND hwnd)
{
FARPROC lpfnDlg;

	lpfnDlg = (FARPROC) MakeProcInstance((FARPROC)WMSProc, hInst);
	DialogBox(hInst, MAKEINTRESOURCE(IDD_WMS), hwnd, (DLGPROC)lpfnDlg);
#ifndef WIN32
	FreeProcInstance((FARPROC)lpfnDlg);
#endif

	return;
}    


            
BOOL WINAPI WMSProc(HWND  hDlg,UINT  uMsg,WPARAM  wParam,LPARAM  lParam)
{
	switch(uMsg) {
		case WM_INITDIALOG:
			// get WMS information for display
			ODMWFGetWMSInfo(odmwfHandle,wmsid,&verno,&extensions);
			wsprintf(version,"%d",verno);
			wsprintf(extens,"%ld",extensions);
			SetDlgItemText(hDlg, IDC_WMSID,wmsid);
			SetDlgItemText(hDlg, IDC_VERSION, version);
			SetDlgItemText(hDlg, IDC_EXTENSION, extens);
			break;
	
	
		case WM_COMMAND:
			switch(GET_WM_COMMAND_ID(wParam, lParam)) {
			 	case IDOK:
					EndDialog(hDlg, NULL);
					break;
					
				default:
					return FALSE;
			}// switch GET_WM_COMMAND
			break;
			
		default:
			return FALSE;
	}// switch uMsg
	
	return(TRUE);
}
