#------------------------------------------------------------
# WFS16.MAK   Makefile for MSVC 1.5x Compilers
#
# Builds WFSERVER.DLL (the 16-bit Workflow Server)
#------------------------------------------------------------

#===== NAME OF PROJECT =====
PROJ = WFSERVER
PROJ_DIR = s:\odmawf\wfserver
OUTDIR = S:\ODMAWF\WFSERVER\OUT16^\




#===== WHERE ARE YOUR MSVC BINARIES =====
BIN = d:\msvc\bin


#===== INCLUDE DIRECTORIES =====
INCLUDE = d:\msvc\include
WF_INC = s:\odmawf\odmawf^\

#===== LIB DIRECTORIES =====
LIB = d:\msvc\lib
MFC_LIB = d:\msvc\mfc\lib



#===== COMPILER & OPTIONS =====
CC = $(BIN)\cl /I$(INCLUDE) /I$(WF_INC)
CFLAGS = /nologo /G2 /W3 /Zi /ALw /Od /D "_DEBUG" /GD /Fd"out16/WFSERVER.PDB" /Fr"out16/"


#===== RESOURCE COMPILER & OPTIONS =====
RC = $(BIN)\rc
RC_FLAGS = /r /fo.\out16/wfserver.res


#===== LINK & OPTIONS =====
LINK = $(BIN)\link
L_FLAGS = /NOLOGO /NOD /NOE /PACKC:61440 /ALIGN:16 /ONERROR:NOEXE /CO /MAP:FULL



#===== BSCMAKE & OPTIONS =====
BSCMAKE = $(BIN)\bscmake
BSC_FLAGS = /o$(OUTDIR)"wfserver.bsc"


#===== IMPLIB =====
IMPLIB = $(BIN)\implib


LIBS = oldnames.lib libw.lib ldllcew.lib commdlg.lib olecli.lib olesvr.lib shell.lib ole2.lib
DEFFILE = wfs16.def


ALL : $(OUTDIR)WFSERVER.DLL $(OUTDIR)WFSERVER.BSC

SBRS   = $(OUTDIR)WFSLIST.SBR \
         $(OUTDIR)WFSDIALG.SBR \
         $(OUTDIR)WFSERVER.SBR \
         $(OUTDIR)WFSAPP.SBR \
         $(OUTDIR)WFSWF.SBR

         
L_OBJS = $(OUTDIR)WFSLIST.OBJ \
         $(OUTDIR)WFSDIALG.OBJ \
         $(OUTDIR)WFSERVER.OBJ \
         $(OUTDIR)WFSAPP.OBJ \
         $(OUTDIR)WFSWF.OBJ

             
$(OUTDIR)WFSERVER.BSC: $(SBRS)
	$(BSCMAKE) @<<
	$(BSC_FLAGS) $(SBRS)
<<

 
 
$(OUTDIR)WFSERVER.DLL:: $(L_OBJS) $(OUTDIR)WFSERVER.RES $(DEFFILE)
	echo >nul @<<WFS16.CRF
$(OUTDIR)WFSLIST.OBJ +
$(OUTDIR)WFSDIALG.OBJ +
$(OUTDIR)WFSERVER.OBJ +
$(OUTDIR)WFSAPP.OBJ +
$(OUTDIR)WFSWF.OBJ
$(OUTDIR)WFSERVER.DLL
$(OUTDIR)WFSERVER.MAP
$(LIB)\+
$(MFC_LIB)\+
$(LIBS)
$(DEFFILE);
<<
   $(LINK) $(L_FLAGS) @WFS16.CRF
   $(RC) /I$(INCLUDE) $(OUTDIR)WFSERVER.RES $@
   $(IMPLIB) /nowep $(OUTDIR)WFSERVER.LIB $(OUTDIR)WFSERVER.DLL
   



#----- DEPENDENCIES FOR SOURCE FILES -----
DEP = $(WF_INC)odmwfcom.h \
      wfserver.h \
      wfserver.rh \
      $(WF_INC)odmawf.h \
      $(WF_INC)odma.h
             
   
#----- CLIENT -----
$(OUTDIR)WFSLIST.OBJ: WFSLIST.CPP $(DEP)
	$(CC) $(CFLAGS) /Fo$(OUTDIR) /c WFSLIST.CPP
      
      
#----- INIT -----
$(OUTDIR)WFSDIALG.OBJ: WFSDIALG.CPP $(DEP)
	$(CC) $(CFLAGS) /Fo$(OUTDIR) /c WFSDIALG.CPP


#----- ODMWFENT -----
$(OUTDIR)WFSERVER.OBJ: WFSERVER.CPP $(DEP)
	$(CC) $(CFLAGS) /Fo$(OUTDIR) /c WFSERVER.CPP
      
      
#----- ODMWMS -----
$(OUTDIR)WFSAPP.OBJ: WFSAPP.CPP $(DEP)
	$(CC) $(CFLAGS) /Fo$(OUTDIR) /c WFSAPP.CPP


#----- REGISTRY -----
$(OUTDIR)WFSWF.OBJ: WFSWF.CPP $(DEP)
	$(CC) $(CFLAGS) /Fo$(OUTDIR) /c WFSWF.CPP


#----- RES -----
$(OUTDIR)WFSERVER.RES: WFSERVER.RC WFSERVER.RH
   $(RC) /I$(INCLUDE) $(RC_FLAGS) WFSERVER.RC
