/* wfsdialg.cpp - Procs for sample WMS dialogs.
 *
 * Written by D. Hamson, Novell
 *
 * COPYRIGHT (C) 1995
 * AIIM International
 * All Rights Reserved
 */


#include <windows.h>
#include <windowsx.h>
#include "wfserver.h"
#include "wfserver.rh"

// Global declared in wfsapp.cpp
extern WorkflowList *WorkList;

// proc for the WMS inbox.  Shows all workflows and allows one 
// to be selected.
BOOL CALLBACK _export SelectWorkflowProc(HWND hwndDlg, UINT message, WPARAM wParam,
LPARAM lParam)
{
	static char FAR *WfId;
	int i, count;
	Workflow *pWf;
	char *lp;

	switch(message) {
		case WM_INITDIALOG:
			// put all workflows into the list
			WfId = (char FAR *)lParam;
			for(i=0,count=0;i<MAXWORKFLOWS;i++) {
				pWf = WorkList->GetWorkflowByIndex(i);
				if (pWf == NULL)
					continue;

				lp = pWf->GetWfId();
				SendDlgItemMessage(hwndDlg, IDC_SELECT, LB_ADDSTRING, 0, (LPARAM)lp);
				count++;
			}
			if (count == 0)
				EnableWindow(GetDlgItem(hwndDlg, IDOK), FALSE);
			else
				SendDlgItemMessage(hwndDlg, IDC_SELECT, LB_SETCURSEL, 0, 0);

			return TRUE;
		case WM_COMMAND:
			switch(GET_WM_COMMAND_ID(wParam, lParam)) {
				case IDC_SELECT:
					if (GET_WM_COMMAND_CMD(wParam, lParam) == LBN_DBLCLK) {
						SendMessage(hwndDlg, WM_COMMAND, (WPARAM)IDOK, (LPARAM)lParam);
					}
					break;
				case IDOK:
					i = (int) SendDlgItemMessage(hwndDlg, IDC_SELECT, LB_GETCURSEL, 0,0);
					SendDlgItemMessage(hwndDlg, IDC_SELECT,LB_GETTEXT, i,
						(LPARAM)WfId);
					// Fall Through here
				case IDCANCEL:
					EndDialog(hwndDlg,wParam);
					return TRUE;
			}
	}
	return FALSE;
}

