/* wfserver.cpp - Entry point, initialization, cleanup, etc. for ODMA WF
 *	sample WMS.
 *
 * Written by D. Hamson, Novell
 *
 * COPYRIGHT (C) 1995
 * AIIM International
 * All Rights Reserved
 */



#include <windows.h>

#ifndef WIN32
#include "memory.h"
#include "compobj.h"
#else
#include "objbase.h"
#endif
#include "initguid.h"
#include "wfserver.h"

// Global
HINSTANCE NEAR hInst;


#ifdef WIN32
BOOL WINAPI DllMain(HANDLE hModule, DWORD fdwReason, LPVOID lpvReserved)
{
	hInst = hModule;
	return 1;
}
#else
int PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize,
LPSTR lpCmdLine)
{
	/* avoid compiler warnings about unused parameters. */
	hInst = hInstance;
	wDataSeg = wDataSeg;
	lpCmdLine = lpCmdLine;

	/* undo the lock on the data segment that was automatically
		placed by the call to LocalInit() in the startup code. */
	if (cbHeapSize)
		UnlockData(0);

	return 1;
}
#endif


/* ODMWFGetODMINterface - This is the main entry point into the WMS from
	the ODMAWF connection manager. */
HRESULT WINAPI _export ODMWFGetODMInterface(REFIID riid, LPVOID FAR *ppvObj,
LPUNKNOWN pUnkOuter, LPVOID pReserved, LPSTR lpszAppId, DWORD dwEnvData)
{
	Application *pApp;
	HRESULT hRes;

	*ppvObj = NULL;

	//  Create an application object, this sample WMS's implemention
	//  of the ODMWF interface.  
	pApp = new Application(pUnkOuter, dwEnvData);

	if (pApp == NULL) {
		MessageBox((HWND)dwEnvData, "Memory allocation failure", WMSNAME, MB_OK);
		return ResultFromScode(E_OUTOFMEMORY);
	}

	/* get the requested interface on the application object */
	hRes = pApp->GetInterface(riid,ppvObj);

	if(*ppvObj)
		((LPUNKNOWN)(*ppvObj))->Release();  /* balances the ref count from 'new' */
	else
		delete pApp;

	return hRes;

}

