/* wfserver.h - Header for sample WMS.
 *
 * COPYRIGHT (C) 1994, 1995
 * AIIM International
 * All Rights Reserved
 */


#include <windows.h>
#include "odmwfcom.h"

// information about this WMS
#define WMSID "WFSERVER"
#define WMSNAME "ODMA WF 1.0 Sample WMS"
#define MAXDOCID	255
#define MAXDOCS	5
#define MAXWORKFLOWS 20   // If you change this, check out the buffer
						  // in wfslist.cpp for the workflowlist 
						  // constructor.  2048 might not be enough.

#define NC(a,b) a##::##b

// Message crackers for 16 & 32 bit windows
#ifdef WIN32
#ifndef GET_WM_COMMAND_CMD
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(wp)
#endif
#ifndef GET_WM_COMMAND_ID
#define GET_WM_COMMAND_ID(wp, lp)   LOWORD(wp)
#endif
#ifndef GET_WM_COMMAND_HWND
#define GET_WM_COMMAND_HWND(wp, lp) (HWND)lp)
#endif
#else
#ifndef GET_WM_COMMAND_CMD
#define GET_WM_COMMAND_CMD(wp, lp)  HIWORD(lp)
#endif
#ifndef GET_WM_COMMAND_ID
#define GET_WM_COMMAND_ID(wp, lp)   (wp)
#endif
#ifndef GET_WM_COMMAND_HWND
#define GET_WM_COMMAND_HWND(wp, lp) ((HWND)LOWORD(lp))
#endif
#endif


// definition of the Application class
class Application {
	public:
		Application(LPUNKNOWN pUnkOuter, DWORD dwEnvData);
		~Application();
		HRESULT GetInterface(REFIID riid, LPVOID FAR *ppvObj);

	private:
		//IUnknown implementation
		struct CUnknown : IUnknown {
			CUnknown(Application *pObject) { m_pObject = pObject; }

			STDMETHOD(QueryInterface) (REFIID riid, LPVOID FAR* ppvObj);
			STDMETHOD_(ULONG,AddRef) (VOID);
			STDMETHOD_(ULONG,Release) (VOID);

			private:
				Application *m_pObject;   // pointer to parent object
		};

		friend CUnknown;
		CUnknown m_Unknown;

		// IODMWFWorkMan interface
		struct CODMWFWorkMan : IODMWFWorkMan {
			CODMWFWorkMan(Application *pObject) { m_pObject = pObject; }
			~CODMWFWorkMan() {};

			//*** IUnknown ***
			STDMETHOD(QueryInterface) (REFIID riid, LPVOID FAR* ppvObj);
			STDMETHOD_(ULONG,AddRef) (VOID);
			STDMETHOD_(ULONG,Release) (VOID);

			// *** IODMWFWorkMan methods ***
			STDMETHOD_(ODMSTATUS, NewObject)(LPSTR lpszWorkflowId, LPDWORD pdwFlags);
			STDMETHOD_(ODMSTATUS, SelectObject)(LPSTR lpszWorkflowId, LPDWORD pdwFlags);
			STDMETHOD_(ODMSTATUS, InsertItem) (LPSTR lpszWorkflowId, WORD wItemNumber,
				LPSTR lpszDocIdentifier);
			STDMETHOD_(ODMSTATUS, RemoveItem) (LPSTR lpszWorkflowId, WORD wItemNumber);
			STDMETHOD_(ODMSTATUS, GetItem) (LPSTR lpszWorkflowId, WORD wItemNumber,
				LPSTR lpszDocIdentifier);
			STDMETHOD_(ODMSTATUS, ProcessObject) (LPSTR lpszWorkflowId, LPDWORD pdwFlags);
			STDMETHOD_(ODMSTATUS, GetObjectInfo) (LPSTR lpszWorkflowId, WORD attribute,
				LPSTR lpszData, WORD datalen);
			STDMETHOD_(ODMSTATUS, SetObjectInfo) (LPSTR lpszWorkflowId, WORD attribute,
				LPSTR lpszData);
			STDMETHOD_(void, Activate) (WORD action, LPSTR lpszWorkflowId);
			STDMETHOD_(void, GetWMSInfo) (LPSTR wmsId, LPWORD pwVerNo,
				LPDWORD pdwExtensions);

			private:
			Application *m_pObject;					// pointer to parent object
		};

		friend CODMWFWorkMan;
		CODMWFWorkMan m_ODMWFWorkMan;

	private:
		DWORD m_dwRefs;
		LPUNKNOWN m_pUnkOuter;
		HWND m_clientWind;
};

// definition of the document class
// (a pretty trival class)
class Document {
	private:
		char	DocId[MAXDOCID];
	public:
		Document() {};
		Document(char *DId) {strncpy(DocId,DId,MAXDOCID);};
		~Document() {};
		char *GetDocId(void) {return DocId;};
		void SetDocId(char *DId) {strncpy(DocId,DId,MAXDOCID);};
};

// definition of the Workflow class
class Workflow {
	private:
		char		WfId[80];
		char		Author[30];
		char		Name[80];
		char		Status[30];
		char		TitleText[80];
		WORD		ItemCount;
		char		UserId[8];
		char		UserName[30];

		Document	*List[MAXDOCS];

	public:
		Workflow();
	    Workflow(LPSTR lpszWfId);
		~Workflow() {};
		void WriteInfo(void);
		LPSTR GetWfId(void) { return WfId; };
		LPSTR GetStatus(void) {return Status; };
		ODMSTATUS InsertDocument(WORD wItemNumber,LPSTR lpszDocIdentifier);
		ODMSTATUS RemoveDocument(WORD wItemNumber);
		ODMSTATUS GetDocument(WORD wItemNumber,LPSTR lpszDocIdentifier);
		ODMSTATUS ChangeStatus(void);
		ODMSTATUS GetInfo(WORD attribute,LPSTR lpszData,WORD datalen);
		ODMSTATUS SetInfo(WORD attribute,LPSTR lpszData);
		};

// definition of the WorkflowList class
class WorkflowList {
	private:
		Workflow *List[MAXWORKFLOWS];
	public:
		WorkflowList();
		~WorkflowList();
		Workflow *NewWorkflow(void);
		Workflow *FindWorkflow(LPSTR lpszWfId);
		Workflow *GetWorkflowByIndex(int i);
		void RemoveWorkflow(LPSTR lpszWfId);
};

// Local prototypes
BOOL CALLBACK _export SelectWorkflowProc(HWND hwndDlg, UINT message, WPARAM wParam,
LPARAM lParam);


