/* wfslist.cpp - Implementation of the WorkflowList object for the sample WMS.
 *	This list is persistent and uses an .INI file as a data store.
 *
 * Written by D. Hamson, Novell
 *
 * COPYRIGHT (C) 1995
 * AIIM International
 * All Rights Reserved
 */




#include "wfserver.h"


// constructor, reads wfserver.ini for the list
WorkflowList::WorkflowList(void)
{
	int i;
	char *buff, *entry;

	for(i=0;i<MAXWORKFLOWS;i++)
		List[i] = NULL;

	buff = new char[2048];

	if (buff) {
		// note that the number of workflows is limited, arbitrarily in this WMS
		// to however many IDs fit in 2048 bytes.
		// This is not the only limit!  The List[] data member's size is a hard limit.
		GetPrivateProfileString("WorkflowList",NULL,"",buff,2048,"WFSERVER.INI");
		// for each existing workflow, create a workflow object
		for(i=0, entry=buff; *entry; i++, entry += strlen(entry) + 1)
			List[i] = new Workflow(entry);

		delete [] buff;
	}
}

// destructor, save the workflow list and delete the workflow objects
WorkflowList::~WorkflowList(void)
{
	int i;

	// wipe out the previous list
	WritePrivateProfileString("WorkflowList",NULL,NULL,"WFSERVER.INI");

	for(i=0;i<MAXWORKFLOWS;i++) {
		if (List[i]) {
			List[i]->WriteInfo();
			delete List[i];
		}
	}
}

// create a new workflow and put it in the list
Workflow *WorkflowList::NewWorkflow(void)
{
	int i;
	Workflow *wf = NULL;

	for(i=0;i<MAXWORKFLOWS;i++)
		if (List[i] == NULL) {
			List[i] = new Workflow;
			wf = List[i];
			break;
		}

	return wf;
}

// locate a workflow by id
Workflow *WorkflowList::FindWorkflow(LPSTR lpszWfId)
{
	int i;
	Workflow *wf = NULL;

	for(i=0;i<MAXWORKFLOWS;i++) {
		if (List[i]) {
			if (!strcmp(List[i]->GetWfId(),lpszWfId)) {
				wf = List[i];
				break;
			}
		}
	}

	return wf;
}

// locate a workflow by position
Workflow *WorkflowList::GetWorkflowByIndex(int i)
{
	Workflow *wf = NULL;

	if (i<MAXWORKFLOWS)
		wf = List[i];

	return wf;
}

// remove a workflow by id
void WorkflowList::RemoveWorkflow(LPSTR lpszWfId)
{
	int i;
	Workflow *wf = NULL;

	for(i=0;i<MAXWORKFLOWS;i++) {
		if (List[i]) {
			if (!strcmp(List[i]->GetWfId(),lpszWfId)) {
				wf = List[i];
				delete wf;
				List[i] = NULL;
				break;
			}
		}
	}

	return;
}




